/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.beans.MethodInfo;
import shohaku.core.beans.ParameterInfo;
import shohaku.core.beans.ParametersInfo;

/**
 * <code>MethodInfo.METHOD</code> を持つ <code>shohaku.core.beans.MethodInfo</code> 型のデータを生成する値型のノードを提供します。
 */
public class MethodInfoNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        String methodName = getAttribute("name");
        List params = new ArrayList();
        for (Iterator i = getNodeContext().valueElementIterator(); i.hasNext();) {
            Object o = ((Node) i.next()).getNodeValue();
            if (o == null || !(o instanceof ParameterInfo)) {
                throw new CompositeException("要素ノードは ParameterInfo 型を返す必要が有ります。element value:" + o);
            }
            params.add(o);
        }
        ParameterInfo[] parameters = (ParameterInfo[]) params.toArray(new ParameterInfo[0]);
        return new MethodInfo(methodName, new ParametersInfo(parameters), MethodInfo.METHOD);
    }

}
