/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node.beans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.beans.ParameterInfo;

/**
 * メソッドを呼び出しリターン値を返すノードを提供します。
 */
public class CallMethodNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        String methodName = getAttribute("method");
        Class type = null;
        Object object = null;

        type = getFeature().getAttributeToClass(this, "class");
        if (null == type) {
            object = getFeature().getAttributeRef(this, "ref");
            if (null == object) {
                throw new CompositeException("参照先の指定に誤りが有ります。");
            }
            type = object.getClass();
        }
        ArrayList types = new ArrayList();
        ArrayList methodArgs = new ArrayList();
        for (Iterator i = getNodeContext().valueElementIterator(); i.hasNext();) {
            ParameterInfo param = (ParameterInfo) ((Node) i.next()).getNodeValue();
            types.add(param.getType());
            methodArgs.add(param.getValue());
        }
        try {
            Class[] parameterTypes = (Class[]) types.toArray(new Class[0]);
            Method method = type.getMethod(methodName, parameterTypes);
            return method.invoke(object, methodArgs.toArray());
        } catch (Exception e) {
            throw new CompositeException("不正なメソッド情報です。", e);
        }
    }

}
