/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.composer.node.beans;

import java.util.List;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.beans.BindMethod;
import shohaku.core.beans.BindParameterInfo;
import shohaku.core.beans.ClassInfo;
import shohaku.core.lang.Eval;

/**
 * <code>shohaku.core.beans.BindParameterInfo</code> 型のデータを生成する値型のノードを提供します。
 */
public class BindParameterInfoNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        List args = getNodeContext().getValueElementChildren();
        if (args.size() > 1) {
            throw new CompositeException("要素が１個以上の数指定されています size:" + args.size());
        }
        Object value = null;
        Class defType = null;
        if (!args.isEmpty()) {
            value = ((Node) args.get(0)).getNodeValue();
            if (value instanceof ClassInfo) {
                defType = ((ClassInfo) value).getObjectType();
            } else {
                defType = value.getClass();
            }
        }
        Class type = getFeature().getAttributeToClass(this, "type", defType);

        String name = getAttribute("name");
        if (Eval.isBlank(name)) {
            throw new CompositeException();
        }

        int rule = BindMethod.BIND_RULE_FINAL;
        boolean bfinal = getFeature().getBoolean(getAttribute("final", "false"));
        if (bfinal && args.isEmpty()) {
            throw new CompositeException();
        }
        if (bfinal) {
            rule = BindMethod.BIND_RULE_FINAL;
        } else {
            if (!args.isEmpty()) {
                rule = BindMethod.BIND_RULE_OVERWRITE;
            } else {
                rule = BindMethod.BIND_RULE_REQUIRED;
            }
        }

        return new BindParameterInfo(type, value, name, rule);

    }

}
