/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.composer.node.beans;

import java.util.ArrayList;
import java.util.Iterator;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.beans.BindMethod;
import shohaku.core.beans.BindMethodBuilder;
import shohaku.core.beans.BindParameterInfo;
import shohaku.core.beans.BindParametersInfo;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.lang.Eval;

/**
 * <code>shohaku.core.beans.BindMethod</code> 型のデータを生成する値型のノードを提供します。
 */
public class BindMethodNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        //BindMethodBuilder
        BindMethodBuilder builder = new BindMethodBuilder();

        String methodName = getAttribute("name");
        if (Eval.isBlank(methodName)) {
            throw new CompositeException("不正なメソッド名です。");
        }
        Class type = null;
        Object object = null;
        type = getFeature().getAttributeToClass(this, "class");
        if (null == type) {
            Object ref = getFeature().getAttributeRef(this, "ref");
            if (null == ref) {
                throw new CompositeException("参照先の指定に誤りが有ります。");
            }
            if (ref instanceof Class) {
                type = (Class) ref;
                object = null;
            } else {
                type = ref.getClass();
                object = ref;
            }
        }

        ArrayList l = new ArrayList();
        for (Iterator i = getNodeContext().valueElementIterator(); i.hasNext();) {
            Object e = ((Node) i.next()).getNodeValue();
            if (e instanceof BindParameterInfo) {
                l.add(e);
            }
        }
        BindParameterInfo[] bindParams = (BindParameterInfo[]) l.toArray(new BindParameterInfo[0]);
        builder.setMethod(type, object, methodName, new BindParametersInfo(bindParams));

        //generate BindMethod
        BindMethod bindMethod;
        try {
            bindMethod = builder.bind();
        } catch (InvocationBeansException e) {
            throw new CompositeException(e);
        }
        return bindMethod;
    }

}
