/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node.beans;

import java.util.Iterator;

import shohaku.composer.CompositeException;
import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;
import shohaku.core.beans.BeansFactory;
import shohaku.core.beans.ClassInfo;
import shohaku.core.beans.FactoryMethodInfo;
import shohaku.core.beans.FieldInfo;
import shohaku.core.beans.MethodInfo;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;

/**
 * <code>shohaku.core.beans.BeansFactory</code> 型のデータを生成する値型のノードを提供します。
 */
public class BeansFactoryNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        //BeansFactory.type
        String instanceType = this.getAttribute("instance", BeansFactory.SINGLETON);

        //generate ClassInfo
        ClassInfo ci = new ClassInfo();

        //load class
        String className = this.getAttribute("class", "java.lang.Object");
        final Class objectClass;
        try {
            objectClass = ResourceLoader.getClass(className, getClassLoader());
        } catch (NoSuchResourceException e) {
            throw new CompositeException("illegal class name is specified. " + className, e);
        }
        ci.setObjectType(objectClass);

        //get FieldInfo's or MethodInfo's
        for (Iterator i = getNodeContext().valueElementIterator(); i.hasNext();) {
            Node n = (Node) i.next();
            Object o = n.getNodeValue();

            if (o instanceof FieldInfo) {
                ci.addField((FieldInfo) o);
            } else if (o instanceof MethodInfo) {
                ci.addInitMethod((MethodInfo) o);
            } else if (o instanceof FactoryMethodInfo) {
                if (ci.getFactory() != null) {
                    throw new CompositeException("生成ノードの複数指定は不正です。element:" + o);
                }
                ci.setFactory((FactoryMethodInfo) o);
            } else {
                throw new CompositeException("不正な型の要素ノードです。element:" + o);
            }
        }

        //generate BeansFactory
        return new BeansFactory(ci, ci.getObjectType(), instanceType);
    }

}
