/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node.base;

import java.util.Iterator;

import shohaku.composer.Node;
import shohaku.composer.node.AbstractValueNode;

/**
 * 文字列型のデータを表す値型のノードです。 <br>
 * <br>
 * 値の生成規則： <br>
 * 値型の子エレメントが存在する場合は、全ての子エレメントの値を文字列として連結して値とします。 <br>
 * 値型の子エレメントが存在しない場合は、テキストノードを連結して値とします。 <br>
 * <br>
 */
public class StringNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        StringBuffer buff = new StringBuffer();
        for (Iterator i = getNodeContext().valueElementIterator(); i.hasNext();) {
            buff.append(((Node) i.next()).getNodeValue());
        }
        if (buff.length() == 0) {
            for (Iterator i = getNodeContext().textIterator(); i.hasNext();) {
                buff.append(((Node) i.next()).getNodeValue());
            }
            return buff.toString().trim();
        } else {
            return buff.toString();
        }
    }

}
