/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer.node;

/**
 * 値を持つノードを保管する機能の基底実装を提供し実装の負担を最小化します。
 */
public abstract class AbstractValueNode extends AbstractBaseNode {

    /**
     * 有効なノード種別を返却します。
     * 
     * @return 有効なノード種別
     */
    protected int[] getTypes() {
        return new int[] { TYPE_VALUE };
    }

    /**
     * ノードの固有のスコープを返却します。
     * 
     * @return ノードの固有のスコープ
     */
    protected int getNodeScope() {
        return SCOPE_PUBLIC;
    }

    /** 値をキャッシュします。 */
    private Object cacheValue;

    /**
     * 値のキャッシュを返却します。
     * 
     * @return 値のキャッシュ
     */
    protected Object getCacheValue() {
        return cacheValue;
    }

    /**
     * cacheValue を格納します。
     * 
     * @param o
     *            値のキャッシュ
     */
    protected void setCacheValue(Object o) {
        this.cacheValue = o;
    }

    /**
     * ノードの値表現を返却します。
     * 
     * @return ノードの値表現
     */
    public Object getNodeValue() {
        if (null == this.cacheValue) {
            this.cacheValue = generateValue();
        }
        return this.cacheValue;
    }

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    abstract protected Object generateValue();

}
