/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

/**
 * テキストのノードを定義します。
 */
public class TextNode implements Node {

    /* テキスト. */
    private String text;

    /**
     * デフォルトコンストラクタ。
     */
    public TextNode() {
        super();
    }

    /**
     * テキストを格納して初期化します。
     * 
     * @param text
     *            テキスト
     */
    public TextNode(String text) {
        super();
        this.text = text;
    }

    /**
     * テキストを返却します。
     * 
     * @return テキスト
     */
    public Object getNodeValue() {
        return text;
    }

    /**
     * 指定されたノードの種別に属する場合Trueを返却します。
     * 
     * @param type
     *            検証する種別
     * @return 指定されたノードの種別に属する場合True
     */
    public boolean isType(int type) {
        return (type == TYPE_TEXT || type == TYPE_VALUE);
    }

    /*
     * getter
     */

    /**
     * ノードのコンテキスト情報を返却します。
     * 
     * @return ノードのコンテキスト情報
     */
    public NodeContext getNodeContext() {
        return null;
    }

    /**
     * 属性を検索し存在しない場合は拡張属性を検索し値を返却します。 属性名が存在しない場合 <code>null</code> を返す。
     * 
     * @param name
     *            属性名
     * @return 属性値
     */
    public String getAttribute(String name) {
        return null;
    }

    /**
     * 属性を検索し存在しない場合は拡張属性を検索し値を返却します。 属性名が存在しない場合 <code>defaultValue</code> を返す。
     * 
     * @param name
     *            属性名
     * @param defaultValue
     *            属性が存在しない場合に返却される値
     * @return 属性値
     */
    public String getAttribute(String name, String defaultValue) {
        return defaultValue;
    }

    /**
     * テキスト情報を評価して返却します。このノードのテキストをそのまま返します。
     * 
     * @return テキスト情報
     */
    public String getText() {
        return text;
    }

    /**
     * ノードの実際のスコープが指定された種別に属する場合Trueを返却します。
     * 
     * @return ノードの実際のスコープが指定された種別に属する場合True
     */
    public int getScope() {
        return SCOPE_PRIVATE;
    }

    /*
     * Event
     */

    /**
     * 解析処理を開始する直前に初期化の通知を受ける。
     * 
     * @param nodeContext
     *            ノードのコンテキスト情報
     * @throws CompositeException
     *             構成情報例外。
     */
    public void initialize(NodeContext nodeContext) {
        //no op
    }

    /**
     * 解析処理プロセス開始の通知を受ける。 開始タグの解析に対応します。
     * 
     * @throws CompositeException
     *             構成情報例外。
     */
    public void begin() {
        //no op
    }

    /**
     * 子のノードの追加の通知を受ける(空実装)。 子ノードの解析終了直後に対応します。
     * 
     * @param node
     *            子のノード
     * @throws CompositeException
     *             構成情報例外。
     */
    public void child(Node node) {
        //no op
    }

    /**
     * 解析処理プロセス完了通知を受ける(空実装)。 終了タグの解析に対応します。 <br>
     * この通知が完了した段階で値を持つ情報は値の生成を完了している必要がある。
     * 
     * @throws CompositeException
     *             構成情報例外。
     */
    public void end() {
        //no op
    }

    /**
     * 解析処理プロセスを完了の通知を受ける(空実装)。ドキュメント解析処理全体の終了に対応します。
     * 
     * @throws CompositeException
     *             構成情報例外。
     */
    public void finish() {
        //no op
    }

}
