/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

import shohaku.core.collections.Parameters;

/**
 * 個々のノードの構成ルールを表現する機能を提供します。
 */
public class NodeRule {

    /** 何も意味しない構成ルールを定義します。 */
    public static final NodeRule EMPTY_NODERULESET;
    static {
        NodeRule empty = new NodeRule() {
            public Parameters getExAttributes() {
                return Parameters.EMPTY_PARAMETERS;
            }

            public String getClassName() {
                return null;
            }

            public String getPattern() {
                return null;
            }

            public void setExAttributes(Parameters set) {
                // no op
            }

            public void setClassName(String string) {
                // no op
            }

            public void setPattern(String string) {
                // no op
            }
        };
        EMPTY_NODERULESET = empty;
    }

    /* マッピングするXML階層URIの書式パターン。 */
    private String pattern;

    /* 生成するノードのクラス名。 */
    private String nodeClass;

    /* 拡張属性のパラメータリスト。 */
    private Parameters exAttributes;

    /* ノードの属性やテキスト文字列を代入する機能。 */
    private Substitutor substitutor;

    /**
     * ノードのクラス名を返却します。
     * 
     * @return ノードのクラス名
     */
    public String getNodeClass() {
        return nodeClass;
    }

    /**
     * ノードのクラス名を格納します。
     * 
     * @param cname
     *            ノードのクラス名
     */
    public void setNodeClass(String cname) {
        this.nodeClass = cname;
    }

    /**
     * 拡張属性のパラメータリストを返却します。
     * 
     * @return 拡張属性のパラメータリスト。
     */
    public Parameters getExAttributes() {
        return exAttributes;
    }

    /**
     * 拡張属性のパラメータリストを格納します。
     * 
     * @param exAttributes
     *            拡張属性のパラメータリスト。
     */
    public void setExAttributes(Parameters exAttributes) {
        this.exAttributes = exAttributes;
    }

    /**
     * XML階層URIの書式パターンを返却します。
     * 
     * @return XML階層URIの書式パターン
     */
    public String getPattern() {
        return pattern;
    }

    /**
     * XML階層URIの書式パターンを格納します。
     * 
     * @param pattern
     *            XML階層URIの書式パターン
     */
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * ノードの属性やテキスト文字列を代入するオブジェクトを返却します。
     * 
     * @return Substitutor
     */
    public Substitutor getSubstitutor() {
        return substitutor;
    }

    /**
     * ノードの属性やテキスト文字列を代入するオブジェクトを格納します。
     * 
     * @param substitutor
     *            Substitutor
     */
    public void setSubstitutor(Substitutor substitutor) {
        this.substitutor = substitutor;
    }
}