/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

import java.util.Iterator;

/**
 * エレメントの親ノードまたは自身のコンテンツにノードをインクルードする機能を定義します。
 */
public interface IncludeNode {

    /** 展開先：自身のコンテンツ。 */
    int EXPAND_TYPE_CONTENT = 0;

    /** 展開先：親ノードのコンテンツ。 */
    int EXPAND_TYPE_PARENT = 1;

    /**
     * 展開先を返却します。
     * 
     * @return 展開先
     */
    int getExpandType();

    /**
     * 展開するノードを反復子で返却します。 反復子の要素は Node で有る必要がある。
     * 
     * @return 展開するノードを反復子
     */
    Iterator getIncludeNodeIterator();

}
