/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

/**
 * エレメントのコンテンツ情報を評価または再評価する制御を行うノードの機能を定義します。 <br>
 * このインターフェースを実装したノードはコンテンツ情報をキャッシュするかキャッシュをスキップするかを一度決定する事が出来ます。 <br>
 * またキャッシュされたコンテンツ情報を再評価する処理を０回以上繰り返す事が出来ます。 <br>
 * このインタフェースは <code>NotHierarchyNode</code> を継承するためコンテンツ情報の評価先は親ノードと為ります。
 */
public interface EvaluationNode extends CacheContentNode, NotHierarchyNode {

    /*
     * initialize
     */

    /** コンテンツ初期化制御コード：初期化を実行します。 */
    int INIT_BODY = 0;

    /** コンテンツ初期化制御コード：初期化をスキップします。 */
    int SKIP_BODY = 1;

    /**
     * コンテンツ情報を初期化するか否かを返却します。 このメソッド INIT_BODY を返却した場合はコンテンツがキャッシュされ評価を実行する準備が行われます。
     * 
     * @return コンテンツ情報を初期化するか否か
     */
    int doInitBody();

    /*
     * evaluation
     */

    /** コンテンツ評価・再評価制御コード：評価を実行します。 */
    int EVAL_BODY = 2;

    /** コンテンツ評価・再評価制御コード：評価を完了します。 */
    int END_BODY = 3;

    /**
     * コンテンツ情報を評価するか否かを返却します。 このメソッドは doInitBody() が INIT_BODY を返した場合のみ１回以上呼び出される。
     * 
     * @return コンテンツ情報を評価するか否か
     */
    int doEvalBody();

}
