/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

import java.io.InputStream;

/**
 * CompositeRule を生成するファクトリのインターフェースを定義します。
 */
public interface CompositeRuleFactory {

    /**
     * 引数のシステムIDから CompositeRule を生成して返却します。
     * 
     * @param systemId
     *            システムID
     * @return CompositeRule の実装クラスのインスタンス
     */
    CompositeRule create(String systemId);

    /**
     * 引数の入力ストリームから CompositeRule を生成して返却する（任意実装）。
     * 
     * @param inStream
     *            入力ストリーム
     * @return CompositeRule の実装クラスのインスタンス
     */
    CompositeRule create(InputStream inStream);

    /**
     * クラスの生成に使用するクラスリーダを返却します。
     * 
     * @return クラスリーダ
     */
    ClassLoader getClassLoader();

    /**
     * クラスの生成に使用するクラスリーダを格納します。
     * 
     * @param loader
     *            クラスリーダ
     */
    void setClassLoader(ClassLoader loader);

}
