/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

/**
 * XML情報を構造化されたオブジェクトに変換するルールを定義するためのインターフェースを定義します。
 */
public interface CompositeRule {

    /**
     * ノードの構成情報を返却します。
     * 
     * @param namespaceURI
     *            解析対象の名前空間URI
     * @param nodeURI
     *            解析対象のXML階層URI
     * @param tagName
     *            タグ名
     * @return ノード構成情報
     */
    NodeRule findNodeRule(String namespaceURI, String nodeURI, String tagName);

    /**
     * 指定されたIDが示す構造化の拡張機能を返却します。 指定されたIDに対応する拡張機能が存在しない場合 <code>null</code> を返します。
     * 
     * @param id
     *            機能を示すクラス
     * @return 拡張機能
     */
    Object getFeature(Class id);

    /**
     * ドキュメントの公開識別子を返却します。
     * 
     * @param root
     *            ルートノード
     * @return ドキュメントの公開識別子
     */
    String getPublicId(Node root);

    /**
     * ノードの識別子を返却します。
     * 
     * @param node
     *            ノード
     * @return ノードの識別子
     */
    String getNodeId(Node node);

    /*
     * SAX
     */

    /**
     * EntityResolver を返却します。
     * 
     * @return EntityResolver、設定を行わない場合 <code>null</code>
     */
    EntityResolver getEntityResolver();

    /**
     * DTDHandler を返却します。
     * 
     * @return DTDHandler、設定を行わない場合 <code>null</code>
     */
    DTDHandler getDTDHandler();

    /**
     * ErrorHandler を返却します。
     * 
     * @return ErrorHandler、設定を行わない場合 <code>null</code>
     */
    ErrorHandler getErrorHandler();

    /**
     * SAXParserFactory#validating へ設定する値を返却します。
     * 
     * @return 設定値、設定を行わない場合 <code>null</code>
     */
    Boolean getValidating();

    /**
     * SAXParserFactory#namespaceAware へ設定する値を返却します。
     * 
     * @return 設定値、設定を行わない場合 <code>null</code>
     */
    Boolean getNamespaceAware();

}
