/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.composer;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * 定義情報を構造化されたオブジェクトに変換する過程で、何らかの誤りが発見された場合に発生する例外。
 */
public class CompositeException extends RuntimeException {

    /**
     * デフォルトコンストラクタ。
     */
    public CompositeException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public CompositeException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public CompositeException(Throwable cause) {
        super(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public CompositeException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * スタックトレースを出力します。 <br>
     * 起因例外のスタックトレースも出力します。
     */
    public void printStackTrace() {
        super.printStackTrace();
        Throwable cause = getCause();
        if (cause != null) {
            cause.printStackTrace();
        }
    }

    /**
     * PrintWriterにスタックトレースを出力します。 <br>
     * 起因例外のスタックトレースも出力します。
     * 
     * @param w
     *            java.io.PrintWriter
     */
    public void printStackTrace(PrintWriter w) {
        super.printStackTrace(w);
        Throwable cause = getCause();
        if (cause != null) {
            cause.printStackTrace(w);
        }
    }

    /**
     * PrintStreamにスタックトレースを出力します。 <br>
     * 起因例外のスタックトレースも出力します。
     * 
     * @param s
     *            java.io.PrintStream
     */
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        Throwable cause = getCause();
        if (cause != null) {
            cause.printStackTrace(s);
        }
    }

}
