/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shohaku.composer.CompositeContext;
import shohaku.composer.CompositeException;
import shohaku.composer.DocumentContext;
import shohaku.composer.Node;
import shohaku.composer.NodeContext;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;

public class NodeCompositeUtilities {
    public static final Map PRIMITIVE_FOR_TYPE_MAP;
    public static final Map SHORT_NAME_FOR_TYPE_MAP;
    public static final Map PRIMITIVE_CLASS_NAME_MAP;
    private static final Pattern numberPattern;
    private static final Pattern numberRemovePattern;
    private static final Pattern referenceExPattern;
    private static final Pattern referenceExRemovePattern;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put("byte", Byte.TYPE);
        m.put("short", Short.TYPE);
        m.put("int", Integer.TYPE);
        m.put("long", Long.TYPE);
        m.put("float", Float.TYPE);
        m.put("double", Double.TYPE);
        m.put("boolean", Boolean.TYPE);
        m.put("char", Character.TYPE);
        m.put("void", Void.TYPE);
        PRIMITIVE_FOR_TYPE_MAP = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.putAll(PRIMITIVE_FOR_TYPE_MAP);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Byte", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Short", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Integer", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Long", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Float", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Double", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Boolean", clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Character", clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.Void");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Void", clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Object", clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("Class", clazz11);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("java.lang.System");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("System", clazz12);
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        m.put("String", clazz13);
        SHORT_NAME_FOR_TYPE_MAP = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Byte.TYPE, "B");
        m.put(Short.TYPE, "S");
        m.put(Integer.TYPE, "I");
        m.put(Long.TYPE, "J");
        m.put(Float.TYPE, "F");
        m.put(Double.TYPE, "D");
        m.put(Boolean.TYPE, "Z");
        m.put(Character.TYPE, "C");
        m.put(Void.TYPE, "V");
        PRIMITIVE_CLASS_NAME_MAP = Collections.unmodifiableMap(m);
        numberPattern = Pattern.compile("^[-+]?(?:0|0X|0x)?[0-9-a-fA-F](?:[-+0-9-a-fA-F,]*[-+0-9-a-fA-F])?(?:\\.[-+0-9-a-fA-F]+)?$");
        numberRemovePattern = Pattern.compile("^\\+|,");
        referenceExPattern = Pattern.compile("([#$%]\\{(?:\\\\\\}|[^}])*\\})");
        referenceExRemovePattern = Pattern.compile("\\\\\\}");
    }

    public static Class loadClass(String s, NodeContext context) {
        return NodeCompositeUtilities.loadClass(s, context.getDocumentContext());
    }

    public static Class loadClass(String s, DocumentContext context) {
        return NodeCompositeUtilities.loadClass(s, context.getCompositeContext());
    }

    public static Class loadClass(String s, CompositeContext context) {
        return NodeCompositeUtilities.loadClass(s, context.getClassLoader());
    }

    public static Class loadClass(String s, ClassLoader loader) {
        try {
            int offset = s.length();
            StringBuffer aSymbol = new StringBuffer();
            while (s.charAt(offset - 2) == '[' && s.charAt(offset - 1) == ']') {
                offset -= 2;
                aSymbol.append('[');
            }
            boolean isArray = aSymbol.length() > 0;
            String className = isArray ? s.substring(0, offset) : s;
            Class c = (Class)SHORT_NAME_FOR_TYPE_MAP.get(className);
            if (c != null && !isArray) {
                return c;
            }
            if (c != null && isArray) {
                String primitive = (String)PRIMITIVE_CLASS_NAME_MAP.get(c);
                className = primitive == null ? aSymbol + "L" + c.getName() + ";" : aSymbol + primitive;
            }
            return ResourceLoader.getClass((String)className, (ClassLoader)loader);
        }
        catch (NoSuchResourceException e) {
            throw new CompositeException("Class\u60c5\u5831\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f class name:" + s, e);
        }
    }

    public static String toJavaNumberString(CharSequence value) {
        if (numberPattern.matcher(value).matches()) {
            return numberRemovePattern.matcher(value).replaceAll("");
        }
        throw new NumberFormatException("value:" + value);
    }

    public static Node getReferenceNodeById(Node node, String id) {
        return NodeCompositeUtilities.getReferenceNodeById(node.getNodeContext(), id);
    }

    public static Node getReferenceNodeById(NodeContext nodeContext, String id) {
        return NodeCompositeUtilities.getReferenceNodeById(nodeContext.getDocumentContext(), nodeContext.getCompositeContext(), id);
    }

    public static Node getReferenceNodeById(DocumentContext docContext, CompositeContext compContext, String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (-1 == id.lastIndexOf(58)) {
            return docContext.getNodeById(id);
        }
        return compContext.getPublicNodeById(id);
    }

    public static String filterReferenceExpression(DocumentContext context, String s) {
        StringBuffer sb = new StringBuffer(s.length());
        Matcher m = referenceExPattern.matcher(s);
        int i = 0;
        while (i < s.length()) {
            if (m.find(i)) {
                sb.append(s.substring(i, m.start(1)));
                String refex = referenceExRemovePattern.matcher(m.group(1)).replaceAll("}");
                char mark = refex.charAt(0);
                String id = refex.substring(2, refex.length() - 1);
                Object value = NodeCompositeUtilities.getReferenceExpValue(context, mark, id);
                sb.append(value);
                i = m.end(1);
                continue;
            }
            sb.append(s.substring(i));
            break;
        }
        return sb.toString();
    }

    private static boolean contain(String chars, char c) {
        return chars.indexOf(c) >= 0;
    }

    private static Object getReferenceExpValue(DocumentContext context, char mark, String id) {
        Object o = null;
        if (mark == '%') {
            o = context.getCompositeContext().getAttribute(id);
        } else if (mark == '$') {
            o = context.getAttribute(id);
        } else {
            Node val = NodeCompositeUtilities.getReferenceNodeById(context, context.getCompositeContext(), id);
            if (val != null && val.isType(3)) {
                o = val.getNodeValue();
            }
        }
        return o;
    }
}

