/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer.node;

import java.util.Iterator;
import shohaku.composer.CompositeContext;
import shohaku.composer.DocumentContext;
import shohaku.composer.Node;
import shohaku.composer.node.NodeCompositeUtilities;

public class NodeCompositeFeature {
    private final String[] BOOL_STRINGS = new String[]{"true", "false", "yes", "no", "on", "off", "1", "0"};
    private final String[] TRUE_STRINGS = new String[]{"true", "yes", "on", "1"};

    public Class getTextToClass(Node node) {
        return this.getAttributeToClass(node, "%text");
    }

    public Class getAttributeToClass(Node node, String name) {
        String className = node.getAttribute(name);
        if (className == null) {
            return null;
        }
        return NodeCompositeUtilities.loadClass(className, node.getNodeContext());
    }

    public Class getAttributeToClass(Node node, String name, Class defaultValue) {
        Class o = this.getAttributeToClass(node, name);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public Object getTextRef(Node node) {
        return this.getAttributeRef(node, "%text");
    }

    public Object getAttributeRef(Node node, String name) {
        String s = node.getAttribute(name);
        if (s == null) {
            return null;
        }
        s = s.trim();
        Object o = null;
        if (s.length() != 0) {
            if (s.charAt(0) == '%') {
                String id = s.substring(1);
                o = this.getCompositeContextAttribute(node, id);
            } else if (s.charAt(0) == '$') {
                String id = s.substring(1);
                o = this.getDocumentContextAttribute(node, id);
            } else {
                String id = s.charAt(0) == '#' ? s.substring(1) : s;
                o = this.getReferenceNodeValue(node, id);
            }
        }
        return o;
    }

    public Object getAttributeRef(Node node, String name, Object defaultValue) {
        Object o = this.getAttributeRef(node, name);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public String getTextString(Node node) {
        StringBuffer sb = new StringBuffer();
        Iterator i = node.getNodeContext().childIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (!n.isType(3)) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString().trim();
    }

    public boolean isBoolean(String value) {
        int i = 0;
        while (i < this.BOOL_STRINGS.length) {
            if (this.BOOL_STRINGS[i].equalsIgnoreCase(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getBoolean(String value) {
        int i = 0;
        while (i < this.TRUE_STRINGS.length) {
            if (this.TRUE_STRINGS[i].equalsIgnoreCase(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toNumberString(CharSequence value) {
        return NodeCompositeUtilities.toJavaNumberString(value);
    }

    private Object getReferenceNodeValue(Node node, String id) {
        Object o = null;
        Node val = NodeCompositeUtilities.getReferenceNodeById(node, id);
        if (val != null && val.isType(3)) {
            o = val.getNodeValue();
        }
        return o;
    }

    private Object getCompositeContextAttribute(Node node, String id) {
        CompositeContext context = node.getNodeContext().getCompositeContext();
        return context.getAttribute(id);
    }

    private Object getDocumentContextAttribute(Node node, String id) {
        DocumentContext context = node.getNodeContext().getDocumentContext();
        return context.getAttribute(id);
    }
}

