/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer.helpers;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import shohaku.composer.CompositeException;
import shohaku.composer.CompositeRule;
import shohaku.composer.Node;
import shohaku.composer.NodeRule;
import shohaku.core.collections.Parameters;

public class DefaultCompositeRule
implements CompositeRule {
    private Boolean validating;
    private Boolean namespaceAware;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private Map features = new IdentityHashMap();
    private Parameters nodeRuleParameters;
    private String nodeIdAttribute = "id";
    private String publicIdAttribute = "publicId";

    public NodeRule findNodeRule(String namespaceURI, String nodeURI, String tagName) {
        Iterator i = this.nodeRuleParameters.iterator();
        while (i.hasNext()) {
            Parameters.Entry e = (Parameters.Entry)i.next();
            String suffix = e.getName();
            if (!suffix.equals("*") && !nodeURI.endsWith(suffix)) continue;
            return (NodeRule)e.getValue();
        }
        return null;
    }

    public String getPublicId(Node root) {
        return root.getAttribute(this.getPublicIdAttribute());
    }

    public String getNodeId(Node node) {
        return node.getAttribute(this.getNodeIdAttribute());
    }

    public Object getFeature(Class id) {
        Map map = this.features;
        synchronized (map) {
            return this.features.get(id);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Boolean getValidating() {
        return this.validating;
    }

    public void setValidating(Boolean validating) {
        this.validating = validating;
    }

    public Boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(Boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void addFeature(Class id, Object feature) {
        if (!id.isInstance(feature)) {
            throw new CompositeException("not assignable class, id:" + id + " , feature:" + feature);
        }
        Map map = this.features;
        synchronized (map) {
            this.features.put(id, feature);
        }
    }

    public Parameters getNodeRuleParameters() {
        return this.nodeRuleParameters;
    }

    public void setNodeRuleParameters(Parameters params) {
        this.nodeRuleParameters = params;
    }

    public String getNodeIdAttribute() {
        return this.nodeIdAttribute;
    }

    public void setNodeIdAttribute(String string) {
        this.nodeIdAttribute = string;
    }

    public String getPublicIdAttribute() {
        return this.publicIdAttribute;
    }

    public void setPublicIdAttribute(String string) {
        this.publicIdAttribute = string;
    }
}

