/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer.helpers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import shohaku.composer.CompositeRule;
import shohaku.composer.helpers.XMLCompositeRuleFactory;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;

public class CompositeRuleFactory {
    private static final Map composeRuleCache = new HashMap();

    public static CompositeRule getComposeRule(String rulePath, ClassLoader classLoader) throws NoSuchResourceException {
        Map map = composeRuleCache;
        synchronized (map) {
            CompositeRule rule = (CompositeRule)composeRuleCache.get(rulePath);
            if (rule == null) {
                rule = CompositeRuleFactory.loadComposeRule(rulePath, classLoader);
                composeRuleCache.put(rulePath, rule);
            }
            return rule;
        }
    }

    private static CompositeRule loadComposeRule(String rulePath, ClassLoader classLoader) throws NoSuchResourceException {
        InputStream inStream = ResourceLoader.getResourceAsStream((String)rulePath, (ClassLoader)classLoader);
        XMLCompositeRuleFactory factory = new XMLCompositeRuleFactory();
        factory.setClassLoader(classLoader);
        return factory.create(inStream);
    }
}

