/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import org.xml.sax.Attributes;
import shohaku.core.lang.Eval;

public class TagAttributes
implements Attributes {
    private String[] values;

    public TagAttributes() {
        this.values = new String[0];
    }

    public TagAttributes(Attributes attributes) {
        int size = attributes.getLength();
        this.values = new String[size * 5];
        int i = 0;
        int k = 0;
        while (i < size) {
            this.values[k++] = attributes.getLocalName(i);
            this.values[k++] = attributes.getQName(i);
            this.values[k++] = attributes.getType(i);
            this.values[k++] = attributes.getURI(i);
            this.values[k++] = attributes.getValue(i);
            ++i;
        }
    }

    public TagAttributes(TagAttributes tagAttributes) {
        this.values = new String[tagAttributes.values.length];
        System.arraycopy(tagAttributes.values, 0, this.values, 0, this.values.length);
    }

    public int getLength() {
        return this.values.length / 5;
    }

    public String getLocalName(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 0];
    }

    public String getQName(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 1];
    }

    public String getType(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 2];
    }

    public String getURI(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 3];
    }

    public String getValue(int index) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            return null;
        }
        return this.values[index * 5 + 4];
    }

    public int getIndex(String qName) {
        return this.findIndexByQName(qName);
    }

    public String getType(String qName) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    public String getValue(String qName) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    private int findIndexByQName(String qName) {
        int size = this.getLength();
        int i = 0;
        while (i < size) {
            if (qName.equals(this.getQName(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setValue(int index, String value) {
        if (!Eval.isRange((int)index, (int)0, (int)(this.getLength() - 1))) {
            throw new IllegalArgumentException();
        }
        this.values[index * 5 + 4] = value;
    }

    public void setValue(String qName, String value) {
        int index = this.findIndexByQName(qName);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this.values[index * 5 + 4] = value;
    }

    public int getIndex(String uri, String localName) {
        return this.findIndexByUriAndLocalName(uri, localName);
    }

    public String getType(String uri, String localName) {
        int index = this.findIndexByUriAndLocalName(uri, localName);
        return -1 != index ? this.getType(index) : null;
    }

    public String getValue(String uri, String localName) {
        int index = this.findIndexByUriAndLocalName(uri, localName);
        return -1 != index ? this.getValue(index) : null;
    }

    private int findIndexByUriAndLocalName(String uri, String localName) {
        int size = this.getLength();
        int i = 0;
        while (i < size) {
            if (uri.equals(this.getURI(i)) && localName.equals(this.getLocalName(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

