/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import shohaku.composer.CacheContentNode;
import shohaku.composer.Composer;
import shohaku.composer.DocumentContext;
import shohaku.composer.EvaluationNode;
import shohaku.composer.Node;
import shohaku.composer.NodeContext;
import shohaku.composer.NodeCreateRule;
import shohaku.composer.NodeRule;
import shohaku.composer.Substitutor;
import shohaku.composer.TagAttributes;
import shohaku.core.collections.Parameters;

class SAXContentHandler
implements ContentHandler {
    private static final int NO_SKIP_BODY = -1;
    private final Composer composer;
    private final LinkedList stackCreateRule = new LinkedList();
    private final LinkedList createRuleList = new LinkedList();
    private final Substitutor hierarchicalSubstitutor = new HierarchicalSubstitutor(this.stackCreateRule);
    private String currentUri;
    private int skipBody;
    private boolean isCacheNode;
    static /* synthetic */ Class class$0;

    SAXContentHandler(Composer composer) {
        this.composer = composer;
        this.initialize();
    }

    private void initialize() {
        this.currentUri = "";
        this.skipBody = -1;
        this.isCacheNode = false;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.skipBody != -1) {
            ++this.skipBody;
            return;
        }
        try {
            String nodeName = SAXContentHandler.getNodeName(localName, qName);
            this.startElement(namespaceURI, nodeName, localName, qName, new TagAttributes(atts));
        }
        catch (Exception e) {
            this.handleException("Composer.startElement: ", e);
        }
    }

    void startElement(String namespaceURI, String nodeName, String localName, String qName, TagAttributes atts) throws SAXException {
        try {
            this.downCurrentURI(nodeName);
            NodeCreateRule createRule = this.createNodeCreateRule(namespaceURI, nodeName);
            NodeCreateRule parentRule = !this.empty() ? this.peek() : null;
            this.push(createRule);
            createRule.begin(this.currentUri, namespaceURI, nodeName, localName, qName, atts, parentRule);
            Node node = createRule.getNodeObject();
            if (this.size() == 1) {
                DocumentContext context = this.composer.getDocumentContext();
                context.setRoot(node);
                String publicId = this.composer.getCompositeRule().getPublicId(node);
                context.setPublicId(publicId);
            }
            if (node instanceof CacheContentNode) {
                this.isCacheNode = true;
            }
            if (node instanceof EvaluationNode) {
                this.startEvaluation(node);
            }
            this.fireContextStartElement(node);
        }
        catch (Exception e) {
            this.handleException("Composer.startElement: ", e);
        }
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.skipBody != -1) {
            return;
        }
        try {
            if (!this.empty()) {
                NodeCreateRule createRule = this.peek();
                char[] chars = new char[length];
                System.arraycopy(buffer, start, chars, 0, length);
                createRule.addChars(this.currentUri, chars);
            }
        }
        catch (Exception e) {
            this.handleException("Composer.characters: ", e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.skipBody != -1) {
            if (this.skipBody == 0) {
                this.skipBody = -1;
            } else {
                --this.skipBody;
                return;
            }
        }
        try {
            NodeCreateRule createRule = this.pop();
            Node node = createRule.getNodeObject();
            if (node instanceof CacheContentNode) {
                this.isCacheNode = false;
            }
            if (node instanceof EvaluationNode) {
                this.endEvaluation(node);
            }
            String name = SAXContentHandler.getNodeName(localName, qName);
            createRule.end(this.currentUri, namespaceURI, name, localName, qName);
            this.upCurrentURI();
            this.fireContextEndElement(node);
        }
        catch (Exception e) {
            this.handleException("Composer.endElement: ", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            Iterator i = this.createRuleList.iterator();
            while (i.hasNext()) {
                NodeCreateRule createRule = (NodeCreateRule)i.next();
                createRule.finish();
            }
        }
        catch (Exception e) {
            this.handleException("Composer.endDocument: ", e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private boolean empty() {
        return this.size() == 0;
    }

    private int size() {
        return this.stackCreateRule.size();
    }

    private void push(NodeCreateRule createRule) {
        this.stackCreateRule.addLast(createRule);
        this.createRuleList.add(createRule);
    }

    private NodeCreateRule pop() {
        return (NodeCreateRule)this.stackCreateRule.removeLast();
    }

    private NodeCreateRule peek() {
        return (NodeCreateRule)this.stackCreateRule.getLast();
    }

    private void startEvaluation(Node node) {
        int eval = ((EvaluationNode)((Object)node)).doInitBody();
        if (eval == 1) {
            this.skipBody = 0;
        }
    }

    private void endEvaluation(Node node) throws SAXException {
        EvaluationNode bodyEvalNode = (EvaluationNode)((Object)node);
        while (2 == bodyEvalNode.doEvalBody()) {
            this.evaluationChilds(node);
        }
    }

    private void evaluationContent(Node node) throws SAXException {
        NodeContext n = node.getNodeContext();
        String namespaceURI = n.getNodeNamespaceURI();
        String nodeName = n.getNodeName();
        String localName = n.getNodeLocalName();
        String qName = n.getNodeQName();
        TagAttributes atts = n.getElemAttributes();
        this.startElement(namespaceURI, nodeName, localName, qName, atts);
        this.evaluationChilds(node);
        this.endElement(namespaceURI, localName, qName);
    }

    private void evaluationChilds(Node parent) throws SAXException {
        Iterator i = parent.getNodeContext().childIterator();
        while (i.hasNext()) {
            Node child = (Node)i.next();
            if (child.isType(2)) {
                String text = child.getText();
                this.characters(text.toCharArray(), 0, text.length());
                continue;
            }
            this.evaluationContent(child);
        }
    }

    private NodeCreateRule createNodeCreateRule(String namespaceURI, String nodeName) throws SAXException {
        if (this.isCacheNode) {
            NodeRule nodeRule = this.createCacheNodeRule();
            return new NodeCreateRule(this.composer.getDocumentContext(), nodeRule, null);
        }
        NodeRule nodeRule = this.findNodeRule(namespaceURI, nodeName);
        if (nodeRule == null) {
            throw new SAXException("\u30ce\u30fc\u30c9\u306e\u69cb\u6210\u30eb\u30fc\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f uri:" + this.currentUri + ", name:" + nodeName);
        }
        return new NodeCreateRule(this.composer.getDocumentContext(), nodeRule, this.hierarchicalSubstitutor);
    }

    private NodeRule createCacheNodeRule() {
        NodeRule set = new NodeRule();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.composer.CacheNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        set.setNodeClass(clazz.getName());
        set.setExAttributes(Parameters.EMPTY_PARAMETERS);
        set.setPattern(this.currentUri);
        NodeRule nodeRule = set;
        return nodeRule;
    }

    private void downCurrentURI(String name) {
        StringBuffer sb = new StringBuffer(this.currentUri);
        sb.append('/');
        sb.append(name);
        this.currentUri = sb.toString();
    }

    private void upCurrentURI() {
        String uri = this.currentUri;
        int slash = uri.lastIndexOf(47);
        this.currentUri = slash >= 0 ? uri.substring(0, slash) : "";
    }

    private void fireContextStartElement(Node node) {
        this.composer.getDocumentContext().startElement(node);
        if (100 == node.getScope()) {
            this.composer.getCompositeContext().startElement(node);
        }
    }

    private void fireContextEndElement(Node node) {
        this.composer.getDocumentContext().endElement(node);
        if (100 == node.getScope()) {
            this.composer.getCompositeContext().endElement(node);
        }
    }

    private NodeRule findNodeRule(String namespaceURI, String nodeName) {
        return this.composer.getCompositeRule().findNodeRule(namespaceURI, this.currentUri, nodeName);
    }

    private void handleException(String msg, Exception e) throws SAXException {
        if (this.composer.isErrThrowable()) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(msg, e);
        }
        this.error(msg, e);
    }

    private void error(Object message, Throwable t) {
        this.composer.getLogger().error(message, t);
    }

    private static String getNodeName(String localName, String qName) {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        return name;
    }

    private static class HierarchicalSubstitutor
    implements Substitutor {
        private List stack;

        HierarchicalSubstitutor(List stack) {
            this.stack = stack;
        }

        public TagAttributes substitute(DocumentContext context, String uri, String nodeName, TagAttributes atts) {
            ListIterator i = this.stack.listIterator();
            while (i.hasNext()) {
                Substitutor substitutor = ((NodeCreateRule)i.next()).getNodeRule().getSubstitutor();
                if (substitutor == null) continue;
                atts = substitutor.substitute(context, uri, nodeName, atts);
            }
            return atts;
        }

        public String substitute(DocumentContext context, String uri, String nodeName, String text) {
            String rtext = text;
            ListIterator i = this.stack.listIterator();
            while (i.hasNext()) {
                Substitutor substitutor = ((NodeCreateRule)i.next()).getNodeRule().getSubstitutor();
                if (substitutor == null) continue;
                rtext = substitutor.substitute(context, uri, nodeName, rtext);
            }
            return rtext;
        }
    }
}

