/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import shohaku.composer.Composer;
import shohaku.composer.DocumentContext;
import shohaku.composer.Node;
import shohaku.composer.NodeContext;
import shohaku.composer.NodeRule;
import shohaku.composer.NotHierarchyNode;
import shohaku.composer.Substitutor;
import shohaku.composer.TagAttributes;
import shohaku.composer.TextNode;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;

class NodeCreateRule {
    private final Composer composer;
    private final DocumentContext documentContext;
    private final NodeRule nodeRule;
    private final Substitutor substitutor;
    private Node nodeObject;
    private NodeContext nodeContext;
    private StringBuffer charBuffer = new StringBuffer();

    NodeCreateRule(DocumentContext context, NodeRule nodeRule, Substitutor substitutor) {
        this.composer = context.getCompositeContext().getComposer();
        this.documentContext = context;
        this.nodeRule = nodeRule;
        this.substitutor = substitutor;
    }

    void begin(String uri, String namespace, String nodeName, String localName, String qName, TagAttributes attributes, NodeCreateRule parentRule) throws Exception {
        if (this.composer.getLogger().isDebugEnabled()) {
            this.composer.getLogger().debug((Object)("NodeCreateRule#begin():uri:" + uri + ", namespace:" + namespace + ", nodeName:" + nodeName + ", localName:" + localName + ", qName:" + qName + ", attributes:" + attributes));
        }
        if (this.substitutor != null) {
            attributes = this.substitutor.substitute(this.documentContext, uri, nodeName, attributes);
        }
        this.nodeObject = this.createNode();
        boolean isNotHierarchical = this.nodeObject instanceof NotHierarchyNode;
        if (!isNotHierarchical && parentRule != null) {
            this.nodeContext = new NodeContext(this.documentContext, this.nodeRule, parentRule.getNodeObject(), uri, namespace, localName, qName, nodeName, attributes);
            parentRule.addChild(uri, this.nodeObject);
        } else {
            this.nodeContext = new NodeContext(this.documentContext, this.nodeRule, null, uri, namespace, localName, qName, nodeName, attributes);
        }
        this.nodeObject.initialize(this.nodeContext);
        this.nodeObject.begin();
    }

    void addChars(String uri, char[] chars) throws Exception {
        if (this.composer.getLogger().isDebugEnabled()) {
            this.composer.getLogger().debug((Object)("NodeCreateRule#chars():uri:" + uri + ":" + "chars:" + String.valueOf(chars)));
        }
        this.charBuffer.append(chars);
    }

    void addChild(String uri, Node child) throws Exception {
        if (this.composer.getLogger().isDebugEnabled()) {
            this.composer.getLogger().debug((Object)("NodeCreateRule#addChild():uri:" + uri + ", child:" + child.getNodeContext().getNodeName()));
        }
        this.addIfTextNode();
        this.nodeContext.addChild(child);
        this.nodeObject.child(child);
    }

    private void addIfTextNode() throws Exception {
        if (this.charBuffer.length() > 0) {
            String text = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            if (this.substitutor != null) {
                text = this.substitutor.substitute(this.documentContext, this.nodeContext.getNodeURI(), this.nodeContext.getNodeQName(), text);
            }
            TextNode child = new TextNode(text);
            this.nodeContext.addChild(child);
            this.nodeObject.child(child);
        }
    }

    void end(String uri, String namespace, String nodeName, String localName, String qName) throws Exception {
        if (this.composer.getLogger().isDebugEnabled()) {
            this.composer.getLogger().debug((Object)("NodeCreateRule#end():uri:" + uri + ", namespace:" + namespace + ", nodeName:" + nodeName + "localName:" + localName + ", qName:" + qName));
        }
        this.addIfTextNode();
        this.nodeObject.end();
    }

    void finish() throws Exception {
        if (this.composer.getLogger().isDebugEnabled()) {
            this.composer.getLogger().debug((Object)("NodeCreateRule#finish():" + this.nodeObject.getClass()));
        }
        this.nodeObject.finish();
        this.nodeObject = null;
        this.nodeContext = null;
        this.charBuffer = null;
    }

    private Node createNode() throws ObjectCreationException {
        ClassLoader classLoader;
        String className = this.nodeRule.getNodeClass();
        Node ret = (Node)ResourceLoader.getInstance((String)className, (ClassLoader)(classLoader = this.composer.getClassLoader()));
        if (ret == null) {
            throw new ObjectCreationException("className:" + this.nodeRule.getNodeClass());
        }
        return ret;
    }

    Node getNodeObject() {
        return this.nodeObject;
    }

    NodeRule getNodeRule() {
        return this.nodeRule;
    }
}

