/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import shohaku.composer.CompositeContext;
import shohaku.composer.DocumentContext;
import shohaku.composer.Node;
import shohaku.composer.NodeRule;
import shohaku.composer.TagAttributes;
import shohaku.core.collections.Parameters;

public class NodeContext {
    private DocumentContext documentContext;
    private NodeRule nodeRule;
    private Node parent;
    private String nodeURI;
    private String nodeNamespaceURI;
    private String nodeLocalName;
    private String nodeQName;
    private String nodeName;
    private TagAttributes attributes;
    private List children;

    NodeContext(DocumentContext context, NodeRule nodeRule, Node parent, String uri, String namespace, String localName, String qName, String nodeName, TagAttributes attributes) {
        this.documentContext = context;
        this.nodeRule = nodeRule;
        this.parent = parent;
        this.nodeURI = uri;
        this.nodeNamespaceURI = namespace;
        this.nodeLocalName = localName;
        this.nodeQName = qName;
        this.nodeName = nodeName;
        this.attributes = attributes;
        this.children = new LinkedList();
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public CompositeContext getCompositeContext() {
        return this.documentContext.getCompositeContext();
    }

    public String getNodeQName() {
        return this.nodeQName;
    }

    public String getNodeLocalName() {
        return this.nodeLocalName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeNamespaceURI() {
        return this.nodeNamespaceURI;
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public Node getParent() {
        return this.parent;
    }

    public Iterator childIterator() {
        return this.children.iterator();
    }

    public List getChildren() {
        return this.children;
    }

    public Iterator textIterator() {
        final Iterator i = this.childIterator();
        return new Iterator(){
            final Object NULL = new Object();
            final Object NOSUCH = new Object();
            Object next = this.NULL;

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (!n.isType(2)) continue;
                    this.next = n;
                    return true;
                }
                this.next = this.NOSUCH;
                return false;
            }

            public Object next() {
                if (this.next == this.NULL) {
                    throw new IllegalStateException();
                }
                if (this.next == this.NOSUCH) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    public List getTextChildren() {
        LinkedList r = new LinkedList();
        Iterator i = this.textIterator();
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    public Iterator elementIterator() {
        final Iterator i = this.childIterator();
        return new Iterator(){
            final Object NULL = new Object();
            final Object NOSUCH = new Object();
            Object next = this.NULL;

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (n.isType(2)) continue;
                    this.next = n;
                    return true;
                }
                this.next = this.NOSUCH;
                return false;
            }

            public Object next() {
                if (this.next == this.NULL) {
                    throw new IllegalStateException();
                }
                if (this.next == this.NOSUCH) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    public List getElementChildren() {
        LinkedList r = new LinkedList();
        Iterator i = this.elementIterator();
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    public Iterator elementIterator(String nodeName) {
        final Iterator i = this.childIterator();
        final String nm = nodeName;
        return new Iterator(){
            final Object NULL = new Object();
            final Object NOSUCH = new Object();
            Object next = this.NULL;

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (n.isType(2) || !nm.equals(n.getNodeContext().getNodeName())) continue;
                    this.next = n;
                    return true;
                }
                this.next = this.NOSUCH;
                return false;
            }

            public Object next() {
                if (this.next == this.NULL) {
                    throw new IllegalStateException();
                }
                if (this.next == this.NOSUCH) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    public List getElementChildren(String nodeName) {
        LinkedList r = new LinkedList();
        Iterator i = this.elementIterator(nodeName);
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    public Iterator valueIterator() {
        final Iterator i = this.childIterator();
        return new Iterator(){
            final Object NULL = new Object();
            final Object NOSUCH = new Object();
            Object next = this.NULL;

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (!n.isType(3)) continue;
                    this.next = n;
                    return true;
                }
                this.next = this.NOSUCH;
                return false;
            }

            public Object next() {
                if (this.next == this.NULL) {
                    throw new IllegalStateException();
                }
                if (this.next == this.NOSUCH) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    public List getValueChildren() {
        LinkedList r = new LinkedList();
        Iterator i = this.valueIterator();
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    public Iterator valueElementIterator() {
        final Iterator i = this.childIterator();
        return new Iterator(){
            final Object NULL = new Object();
            final Object NOSUCH = new Object();
            Object next = this.NULL;

            public void remove() {
                i.remove();
            }

            public boolean hasNext() {
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (!n.isType(3) || n.isType(2)) continue;
                    this.next = n;
                    return true;
                }
                this.next = this.NOSUCH;
                return false;
            }

            public Object next() {
                if (this.next == this.NULL) {
                    throw new IllegalStateException();
                }
                if (this.next == this.NOSUCH) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    public List getValueElementChildren() {
        LinkedList r = new LinkedList();
        Iterator i = this.valueElementIterator();
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    public Parameters getExAttributes() {
        return this.nodeRule.getExAttributes();
    }

    public String getExAttribute(String name) {
        return (String)this.getExAttributes().getValue(name);
    }

    public String getExAttribute(String name, String defaultValue) {
        return (String)this.getExAttributes().getValue(name, defaultValue);
    }

    public TagAttributes getElemAttributes() {
        return this.attributes;
    }

    public String getElemAttribute(String name) {
        return this.getElemAttributes().getValue(name);
    }

    public String getElemAttribute(String name, String defaultValue) {
        String value = this.getElemAttribute(name);
        return value != null ? value : defaultValue;
    }

    void addChild(Node child) {
        this.children.add(child);
    }
}

