/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.composer.CompositeContext;
import shohaku.composer.CompositeException;
import shohaku.composer.CompositeRule;
import shohaku.composer.Node;

public class DocumentContext {
    private CompositeContext compositeContext;
    private CompositeRule compositeRule;
    private HashMap idsMap = new HashMap();
    private HashMap attributes = new HashMap();
    private String publicId;
    private Node root;

    DocumentContext(CompositeContext compositeContext, CompositeRule compositeRule) {
        this.compositeContext = compositeContext;
        this.compositeRule = compositeRule;
    }

    public Iterator getAttributeNameIterator() {
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getAttributePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap m = new HashMap();
        Set entrys = this.attributes.entrySet();
        Iterator i = entrys.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            if (!name.startsWith(prefix)) continue;
            m.put(name, e.getValue());
        }
        return m;
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.remove(name);
    }

    public Map removeAttributePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap m = new HashMap();
        Object[] keys = this.attributes.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String name = (String)keys[i];
            if (name.startsWith(prefix)) {
                m.put(name, this.attributes.remove(name));
            }
            ++i;
        }
        return m;
    }

    public void removeAttributeAll() {
        this.attributes.clear();
    }

    public Iterator getNodeIdIterator() {
        return this.idsMap.keySet().iterator();
    }

    public Node getNodeById(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return (Node)this.idsMap.get(id);
    }

    private void addReferenceNode(Node node) {
        Node old;
        if (node == null) {
            throw new NullPointerException();
        }
        String id = this.getCompositeRule().getNodeId(node);
        if (id != null && (old = this.idsMap.put(id, node)) != null) {
            this.idsMap.put(id, old);
            throw new CompositeException("That ID has already been registered. id:" + id + ".");
        }
    }

    void startElement(Node node) {
        this.addReferenceNode(node);
    }

    void endElement(Node node) {
    }

    void begin() {
    }

    void finish() {
    }

    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    public CompositeRule getCompositeRule() {
        return this.compositeRule;
    }

    public String getPublicId() {
        return this.publicId;
    }

    void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public Node getRoot() {
        return this.root;
    }

    void setRoot(Node root) {
        this.root = root;
    }
}

