/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.composer.Composer;
import shohaku.composer.CompositeException;
import shohaku.composer.Node;

public class CompositeContext {
    private final Composer composer;
    private HashMap idsMap = new HashMap();
    private HashMap attributes = new HashMap();

    CompositeContext(Composer composer) {
        this.composer = composer;
    }

    public Iterator getAttributeNameIterator() {
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getAttributePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap m = new HashMap();
        Set entrys = this.attributes.entrySet();
        Iterator i = entrys.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            if (!name.startsWith(prefix)) continue;
            m.put(name, e.getValue());
        }
        return m;
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.attributes.remove(name);
    }

    public Map removeAttributePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap m = new HashMap();
        Object[] keys = this.attributes.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String name = (String)keys[i];
            if (name.startsWith(prefix)) {
                m.put(name, this.attributes.remove(name));
            }
            ++i;
        }
        return m;
    }

    public void removeAttributeAll() {
        this.attributes.clear();
    }

    public Iterator getPublicNodeIdIterator() {
        return this.idsMap.keySet().iterator();
    }

    public Node getPublicNodeById(String publicId) {
        if (publicId == null) {
            throw new NullPointerException();
        }
        if (-1 == publicId.lastIndexOf(58)) {
            throw new CompositeException("It is not a public node. id:" + publicId + ".");
        }
        return (Node)this.idsMap.get(publicId);
    }

    private void addPublicReferenceNode(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (100 != node.getScope()) {
            throw new CompositeException("It isn't public node. node:" + node + ".");
        }
        String id = this.composer.getCompositeRule().getNodeId(node);
        if (id != null) {
            String publicId = this.composer.getDocumentContext().getPublicId();
            if (publicId == null || publicId.length() == 0) {
                throw new CompositeException("A public identifier is necessary for the public node. node:" + node + ".");
            }
            id = String.valueOf(publicId) + ':' + id;
            Node old = this.idsMap.put(id, node);
            if (old != null) {
                this.idsMap.put(id, old);
                throw new CompositeException("That ID has already been registered. id:" + id + ".");
            }
        }
    }

    void startElement(Node node) {
        this.addPublicReferenceNode(node);
    }

    void endElement(Node node) {
    }

    void begin() {
    }

    void finish() {
    }

    public ClassLoader getClassLoader() {
        return this.getComposer() == null ? null : this.getComposer().getClassLoader();
    }

    public Composer getComposer() {
        return this.composer;
    }
}

