/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import shohaku.composer.CompositeContext;
import shohaku.composer.CompositeException;
import shohaku.composer.CompositeRule;
import shohaku.composer.DocumentContext;
import shohaku.composer.Node;
import shohaku.composer.SAXContentHandler;

public class Composer {
    private static final Log staticLog;
    private Log log;
    private SAXParser parser;
    private XMLReader reader;
    private SAXParserFactory factory;
    private ClassLoader classLoader;
    private CompositeRule rule;
    private CompositeContext compositeContext;
    private DocumentContext documentContext;
    private boolean errThrowable;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.composer.Composer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        staticLog = LogFactory.getLog((Class)clazz);
    }

    public Composer() {
        this.initialize();
    }

    public void initialize() {
        this.compositeContext = new CompositeContext(this);
        this.log = staticLog;
        this.parser = null;
        this.reader = null;
        this.factory = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.composer.Composer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classLoader = clazz.getClassLoader();
        this.rule = null;
        this.errThrowable = false;
    }

    public void parse(CompositeRule rule, InputStream inStream) {
        this.parse(rule, new InputSource(inStream));
    }

    public void parse(CompositeRule rule, InputSource input) {
        this.parseBegin(rule);
        try {
            this.getXMLReader().parse(input);
        }
        catch (SAXException e) {
            throw new CompositeException("composer parse", e);
        }
        catch (IOException e) {
            throw new CompositeException("composer parse", e);
        }
        this.parseFinish();
    }

    private void parseBegin(CompositeRule rule) {
        this.rule = rule;
        this.documentContext = new DocumentContext(this.compositeContext, this.rule);
        this.compositeContext.begin();
        this.documentContext.begin();
        this.parseBeginSAX(rule);
    }

    private void parseBeginSAX(CompositeRule rule) {
        ErrorHandler errorHandler;
        DTDHandler dtdHandler;
        EntityResolver entityResolver;
        Boolean namespaceAware;
        Boolean dtdValidate = rule.getValidating();
        if (dtdValidate != null) {
            this.setValidating(dtdValidate);
        }
        if ((namespaceAware = rule.getNamespaceAware()) != null) {
            this.setNamespaceAware(namespaceAware);
        }
        if ((entityResolver = rule.getEntityResolver()) != null) {
            this.setEntityResolver(entityResolver);
        }
        if ((dtdHandler = rule.getDTDHandler()) != null) {
            this.setDTDHandler(dtdHandler);
        }
        if ((errorHandler = rule.getErrorHandler()) != null) {
            this.setErrorHandler(errorHandler);
        }
        try {
            this.getXMLReader().setContentHandler(new SAXContentHandler(this));
        }
        catch (SAXException e) {
            throw new CompositeException("call getXMLReader()", e);
        }
    }

    private void parseFinish() {
        this.compositeContext.finish();
        this.documentContext.finish();
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        if (log == null) {
            throw new NullPointerException();
        }
        this.log = log;
    }

    public SAXParserFactory getFactory() {
        if (this.factory == null) {
            try {
                this.factory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError e) {
                this.log.error((Object)"Composer.getFactory: ", (Throwable)e);
                return null;
            }
        }
        return this.factory;
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            this.parser = this.getFactory().newSAXParser();
        }
        catch (Exception e) {
            this.log.error((Object)"Composer.getParser: ", (Throwable)e);
            return null;
        }
        return this.parser;
    }

    public XMLReader getReader() {
        try {
            return this.getXMLReader();
        }
        catch (Exception e) {
            this.log.error((Object)"Composer.getReader:", (Throwable)e);
            return null;
        }
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
            this.reader.setDTDHandler(new DefaultDTDHandler());
            this.reader.setEntityResolver(new DefaultEntityResolver());
            this.reader.setErrorHandler(new DefaultErrorHandler(this));
        }
        return this.reader;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getParser().setProperty(name, value);
    }

    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFactory().getFeature(name);
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(name, value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.getReader().setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.getReader().getEntityResolver();
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.getReader().setDTDHandler(dtdHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.getReader().getDTDHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getReader().setErrorHandler(errorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.getReader().getErrorHandler();
    }

    public boolean isValidating() {
        return this.getFactory().isValidating();
    }

    public void setValidating(boolean validating) {
        this.getFactory().setValidating(validating);
    }

    public boolean isNamespaceAware() {
        return this.getFactory().isNamespaceAware();
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.getFactory().setNamespaceAware(namespaceAware);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isErrThrowable() {
        return this.errThrowable;
    }

    public void setErrThrowable(boolean errThrowable) {
        this.errThrowable = errThrowable;
    }

    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public CompositeRule getCompositeRule() {
        return this.rule;
    }

    public Node getRoot() {
        return this.getDocumentContext() == null ? null : this.getDocumentContext().getRoot();
    }

    private static class DefaultEntityResolver
    implements EntityResolver {
        DefaultEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return null;
        }
    }

    private static class DefaultDTDHandler
    implements DTDHandler {
        DefaultDTDHandler() {
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private final Composer composer;

        DefaultErrorHandler(Composer composer) {
            this.composer = composer;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.composer.getLogger().warn((Object)"ErrorHandler.warning: ", (Throwable)e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.composer.getLogger().error((Object)"ErrorHandler.error: ", (Throwable)e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.composer.getLogger().fatal((Object)"ErrorHandler.fatalError: ", (Throwable)e);
            throw e;
        }
    }
}

