/*
 * Decompiled with CFR 0.152.
 */
package shohaku.composer;

import java.util.Iterator;
import shohaku.composer.Node;
import shohaku.composer.NodeContext;

public abstract class AbstractNode
implements Node {
    private NodeContext nodeContext;

    public boolean isType(int type) {
        return false;
    }

    public Object getNodeValue() {
        return null;
    }

    public NodeContext getNodeContext() {
        return this.nodeContext;
    }

    public String getAttribute(String name) {
        String value = this.getNodeContext().getElemAttribute(name);
        if (value == null) {
            value = this.getNodeContext().getExAttribute(name);
        }
        return value;
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.nodeContext.textIterator();
        while (i.hasNext()) {
            sb.append(((Node)i.next()).getText());
        }
        return sb.toString();
    }

    public int getScope() {
        int scope = this.getNodeScope();
        if (this.nodeContext.getParent() != null) {
            int parentScope = this.nodeContext.getParent().getScope();
            scope = parentScope > scope ? parentScope : scope;
        }
        return scope;
    }

    protected int getNodeScope() {
        return 102;
    }

    public void initialize(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public void begin() {
    }

    public void child(Node node) {
    }

    public void end() {
    }

    public void finish() {
    }
}

