/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import shohaku.core.collections.Parameters;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Eval;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.Expression;
import shohaku.core.util.cel.Literal;
import shohaku.core.util.codec.UnicodeEscapesCoder;

public class PrimitiveExpression
implements Expression {
    private static final Literal[] literals = new Literal[]{new Literal('\u0000', '\u0000'), new Literal('\'', '\'')};
    private static final String NUM_CHARS = "-+xX0123456789abcdefABCDEF.BSILFD";

    public Literal[] getLiteral() {
        return literals;
    }

    public Object execute(CELBinder binder, Literal literal, String expression, int begin, int end, Parameters values) {
        String exp = expression.substring(begin, end).trim();
        if (PrimitiveExpression.literals[0].begin == literal.begin) {
            return this.executeNoLiteral(exp);
        }
        return this.executeCharacter(exp);
    }

    private Object executeNoLiteral(String exp) {
        if ("null".equals(exp)) {
            return null;
        }
        if (Eval.isOrEquals(exp, new Object[]{"true", "false"})) {
            return Boolean.valueOf(exp);
        }
        char numLiteral = exp.charAt(exp.length() - 1);
        String num = exp.substring(0, exp.length() - 1);
        switch (numLiteral) {
            case 'B': {
                return Byte.decode(num);
            }
            case 'S': {
                return Short.decode(num);
            }
            case 'I': {
                return Integer.decode(num);
            }
            case 'L': {
                return Long.decode(num);
            }
            case 'F': {
                return Float.valueOf(num);
            }
            case 'D': {
                return Double.valueOf(num);
            }
        }
        if (Eval.isContains((CharSequence)num, '.')) {
            return Double.valueOf(exp);
        }
        return Integer.decode(exp);
    }

    private Object executeCharacter(String exp) {
        String schar = exp.replaceAll("\\\\'", "'");
        if (schar.length() > 1) {
            schar = UnicodeEscapesCoder.decode(schar);
        }
        schar.length();
        return Boxing.box(schar.charAt(0));
    }

    public int findNextIndex(CELBinder binder, Literal literal, String expression, int begin) {
        if (literals[0].equals(literal)) {
            return this.endLiteralIndexOfByNoLiteral(expression, begin);
        }
        return this.endLiteralIndexOfyByCharacter(expression, begin);
    }

    private int endLiteralIndexOfByNoLiteral(String expression, int begin) {
        if (Eval.isStartsWith(expression, "null", begin)) {
            return begin + "null".length();
        }
        if (Eval.isStartsWith(expression, "true", begin)) {
            return begin + "true".length();
        }
        if (Eval.isStartsWith(expression, "false", begin)) {
            return begin + "false".length();
        }
        int end = begin;
        while (end < expression.length()) {
            if (!Eval.isContains((CharSequence)NUM_CHARS, expression.charAt(end))) break;
            ++end;
        }
        if (end == begin) {
            return -1;
        }
        return end;
    }

    private int endLiteralIndexOfyByCharacter(String expression, int begin) {
        int end = begin + 1;
        while (end < expression.length()) {
            if (-1 == (end = expression.indexOf(39, end))) {
                return -1;
            }
            if (end == 0 || end > 0 && '\\' != expression.charAt(end - 1)) break;
            ++end;
        }
        return end + 1;
    }
}

