/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.util.DateUtils;

class ToStringHelper {
    static final int NORMAL = 0;
    static final int CLASSES = 1;
    static final int DEEP_CLASSES = 2;

    ToStringHelper() {
    }

    static String toString(Object o, int style) {
        if (o == null) {
            return "null";
        }
        Class<?> c = o.getClass();
        StringBuffer buf = new StringBuffer();
        ToStringHelper.appendClass(o, buf, 0, style);
        if (c.isArray()) {
            Class<?> type = c.getComponentType();
            if (type == Character.TYPE) {
                buf.append(ToStringHelper.toString((char[])o));
            } else if (type == Boolean.TYPE) {
                buf.append(ToStringHelper.toString((boolean[])o));
            } else if (type == Byte.TYPE) {
                buf.append(ToStringHelper.toString((byte[])o));
            } else if (type == Short.TYPE) {
                buf.append(ToStringHelper.toString((short[])o));
            } else if (type == Integer.TYPE) {
                buf.append(ToStringHelper.toString((int[])o));
            } else if (type == Long.TYPE) {
                buf.append(ToStringHelper.toString((long[])o));
            } else if (type == Float.TYPE) {
                buf.append(ToStringHelper.toString((float[])o));
            } else if (type == Double.TYPE) {
                buf.append(ToStringHelper.toString((double[])o));
            } else {
                buf.append(ToStringHelper.toString((Object[])o, style));
            }
        } else if (o instanceof Map) {
            buf.append(ToStringHelper.toString((Map)o, style));
        } else if (o instanceof Collection) {
            buf.append(ToStringHelper.toString((Collection)o, style));
        } else if (o instanceof Timestamp) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Time) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Date) {
            buf.append(DateUtils.format(o));
        } else if (o instanceof Calendar) {
            buf.append(DateUtils.format(o));
        } else {
            buf.append(String.valueOf(o));
        }
        return buf.toString();
    }

    static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(a[0]);
        int i = 1;
        while (i < a.length) {
            buf.append(", ");
            buf.append(a[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(Object[] a, int style) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            ToStringHelper.appendObject(a[i], buf, style);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    static String toString(Map m, int style) {
        if (m == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        if (m.size() == 0) {
            buf.append("{}");
        } else {
            buf.append('{');
            boolean st = true;
            Iterator i = m.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (st) {
                    st = false;
                } else {
                    buf.append(", ");
                }
                if (key != null && key.getClass().isArray()) {
                    buf.append(ToStringHelper.toString(key, style));
                } else {
                    ToStringHelper.appendObject(key, buf, style);
                }
                buf.append(':');
                if (value != null && value.getClass().isArray()) {
                    buf.append(ToStringHelper.toString(value, style));
                    continue;
                }
                ToStringHelper.appendObject(value, buf, style);
            }
            buf.append('}');
        }
        return buf.toString();
    }

    static String toString(Collection c, int style) {
        if (c == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        if (c.size() == 0) {
            buf.append("[]");
        } else {
            buf.append('[');
            Iterator i = c.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Object e = i.next();
                if (e != null && e.getClass().isArray()) {
                    ToStringHelper.toString(e, style);
                } else {
                    ToStringHelper.appendObject(e, buf, style);
                }
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
        return buf.toString();
    }

    static String deepToString(Object o, int style) {
        if (o == null) {
            return "null";
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            Class<?> type = c.getComponentType();
            if (type.isPrimitive()) {
                return ToStringHelper.toString(o, style);
            }
            return ToStringHelper.deepToString((Object[])o, style);
        }
        if (o instanceof Map) {
            return ToStringHelper.deepToString((Map)o, style);
        }
        if (o instanceof Collection) {
            return ToStringHelper.deepToString((Collection)o, style);
        }
        return String.valueOf(o);
    }

    static String deepToString(Object[] a, int style) {
        if (a == null) {
            return "null";
        }
        int bufLen = 20 * a.length;
        if (a.length != 0 && bufLen <= 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer buf = new StringBuffer(bufLen);
        ToStringHelper.deepToString(a, buf, new HashSet(), 0, style);
        return buf.toString();
    }

    private static void deepToString(Object[] a, StringBuffer buf, Set dejaVu, int row, int style) {
        if (a == null) {
            buf.append("null");
            return;
        }
        dejaVu.add(a);
        ToStringHelper.appendClass(a, buf, row, style);
        buf.append('[');
        int i = 0;
        while (i < a.length) {
            Object e;
            if (i != 0) {
                buf.append(", ");
            }
            if ((e = a[i]) == null) {
                buf.append("null");
            } else if (dejaVu.contains(e)) {
                buf.append("[...]");
            } else {
                Class<?> eClass = e.getClass();
                if (eClass.isArray()) {
                    Class<?> type = eClass.getComponentType();
                    if (type == Character.TYPE) {
                        buf.append(ToStringHelper.toString((char[])e));
                    } else if (type == Boolean.TYPE) {
                        buf.append(ToStringHelper.toString((boolean[])e));
                    } else if (type == Byte.TYPE) {
                        buf.append(ToStringHelper.toString((byte[])e));
                    } else if (type == Short.TYPE) {
                        buf.append(ToStringHelper.toString((short[])e));
                    } else if (type == Integer.TYPE) {
                        buf.append(ToStringHelper.toString((int[])e));
                    } else if (type == Long.TYPE) {
                        buf.append(ToStringHelper.toString((long[])e));
                    } else if (type == Float.TYPE) {
                        buf.append(ToStringHelper.toString((float[])e));
                    } else if (type == Double.TYPE) {
                        buf.append(ToStringHelper.toString((double[])e));
                    } else {
                        ToStringHelper.deepToString((Object[])e, buf, dejaVu, row + 1, style);
                    }
                } else if (e instanceof Map) {
                    ToStringHelper.deepToString((Map)e, buf, dejaVu, style);
                } else if (e instanceof Collection) {
                    ToStringHelper.deepToString((Collection)e, buf, dejaVu, style);
                } else {
                    ToStringHelper.appendObject(e, buf, style);
                }
            }
            ++i;
        }
        buf.append("]");
        dejaVu.remove(a);
    }

    static String deepToString(Map m, int style) {
        if (m == null) {
            return "null";
        }
        int bufLen = 20 * m.size();
        if (m.size() != 0 && bufLen <= 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer buf = new StringBuffer(bufLen);
        ToStringHelper.deepToString(m, buf, new HashSet(), style);
        return buf.toString();
    }

    private static void deepToString(Map m, StringBuffer buf, Set dejaVu, int style) {
        if (m == null) {
            buf.append("null");
            return;
        }
        dejaVu.add(m);
        ToStringHelper.appendClass(m, buf, style);
        if (m.size() == 0) {
            buf.append("{}");
        } else {
            buf.append('{');
            boolean st = true;
            Iterator i = m.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (st) {
                    st = false;
                } else {
                    buf.append(", ");
                }
                ToStringHelper.append(m, buf, key, dejaVu, style);
                buf.append(':');
                ToStringHelper.append(m, buf, value, dejaVu, style);
            }
            buf.append('}');
        }
    }

    private static void append(Map m, StringBuffer buf, Object o, Set dejaVu, int style) {
        if (o == null) {
            buf.append("null");
            return;
        }
        if (dejaVu.contains(o)) {
            buf.append("[...]");
        } else if (o == m) {
            buf.append("(this Map)");
        } else if (o.getClass().isArray()) {
            ToStringHelper.deepToString((Object[])o, buf, dejaVu, 0, style);
        } else if (o instanceof Map) {
            ToStringHelper.deepToString((Map)o, buf, dejaVu, style);
        } else if (o instanceof Collection) {
            ToStringHelper.deepToString((Collection)o, buf, dejaVu, style);
        } else {
            ToStringHelper.appendObject(o, buf, style);
        }
    }

    static String deepToString(Collection c, int style) {
        if (c == null) {
            return "null";
        }
        int bufLen = 20 * c.size();
        if (c.size() != 0 && bufLen <= 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer buf = new StringBuffer(bufLen);
        ToStringHelper.deepToString(c, buf, new HashSet(), style);
        return buf.toString();
    }

    private static void deepToString(Collection c, StringBuffer buf, Set dejaVu, int style) {
        if (c == null) {
            buf.append("null");
            return;
        }
        dejaVu.add(c);
        ToStringHelper.appendClass(c, buf, style);
        if (c.size() == 0) {
            buf.append("[]");
        } else {
            buf.append('[');
            Iterator i = c.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Object e = i.next();
                ToStringHelper.append(c, buf, e, dejaVu, style);
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
    }

    private static void append(Collection c, StringBuffer buf, Object o, Set dejaVu, int style) {
        if (o == null) {
            buf.append("null");
        } else if (o == c) {
            buf.append("(this Collection)");
        } else if (o.getClass().isArray()) {
            ToStringHelper.deepToString((Object[])o, buf, dejaVu, 0, style);
        } else if (o instanceof Map) {
            ToStringHelper.deepToString((Map)o, buf, dejaVu, style);
        } else if (o instanceof Collection) {
            ToStringHelper.deepToString((Collection)o, buf, dejaVu, style);
        } else {
            ToStringHelper.appendObject(o, buf, style);
        }
    }

    private static void appendObject(Object o, StringBuffer buf, int style) {
        if (o == null) {
            buf.append("null");
            return;
        }
        if (2 == style) {
            ToStringHelper.appendClass(o, buf, style);
        }
        if (o instanceof Timestamp) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Time) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Date) {
            buf.append(DateUtils.format(o));
        } else if (o instanceof Calendar) {
            buf.append(DateUtils.format(o));
        } else {
            buf.append(o);
        }
    }

    private static void appendClass(Object o, StringBuffer buf, int style) {
        ToStringHelper.appendClass(o, buf, -1, style);
    }

    private static void appendClass(Object o, StringBuffer buf, int row, int style) {
        if (1 == style && row == 0 || 2 == style) {
            buf.append('<');
            buf.append(o.getClass().getName());
            buf.append('>');
        }
    }
}

