/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;

public class ResourceLoader {
    private static final Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static Class getClass(String className) throws NoSuchResourceException {
        return ResourceLoader.getClass(className, null);
    }

    public static Class getClass(String className, ClassLoader loader) throws NoSuchResourceException {
        ClassLoader classLoader = loader;
        try {
            if (classLoader != null) {
                return classLoader.loadClass(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            try {
                classLoader = ResourceLoader.getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(className);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                return classLoader.loadClass(className);
            }
            catch (Exception exception3) {
                throw new NoSuchResourceException("Not Find Class:" + className);
            }
        }
    }

    public static URL getResource(String resource) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ResourceLoader.getResource(resource, clazz);
    }

    public static URL getResource(String resource, Class c) throws NoSuchResourceException {
        return ResourceLoader.getResource(resource, c.getClassLoader());
    }

    public static URL getResource(String resource, ClassLoader loader) throws NoSuchResourceException {
        URL url;
        block5: {
            ClassLoader classLoader = null;
            url = null;
            try {
                classLoader = loader;
                if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                    return url;
                }
                classLoader = ResourceLoader.getContextClassLoader();
                if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                    return url;
                }
                url = ClassLoader.getSystemResource(resource);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Not Find Resource '" + resource), (Throwable)e);
            }
        }
        if (url == null) {
            throw new NoSuchResourceException("Not Find Resource '" + resource);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ResourceLoader.getResourceAsStream(resource, clazz);
    }

    public static InputStream getResourceAsStream(String resource, Class c) throws NoSuchResourceException {
        return ResourceLoader.getResourceAsStream(resource, c.getClassLoader());
    }

    public static InputStream getResourceAsStream(String resource, ClassLoader loader) throws NoSuchResourceException {
        InputStream inStream;
        block5: {
            ClassLoader classLoader = null;
            inStream = null;
            try {
                classLoader = loader;
                if (classLoader != null && (inStream = classLoader.getResourceAsStream(resource)) != null) {
                    return inStream;
                }
                classLoader = ResourceLoader.getContextClassLoader();
                if (classLoader != null && (inStream = classLoader.getResourceAsStream(resource)) != null) {
                    return inStream;
                }
                inStream = ClassLoader.getSystemResourceAsStream(resource);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Not Find Resource '" + resource), (Throwable)e);
            }
        }
        if (inStream == null) {
            throw new NoSuchResourceException("Not Find Resource '" + resource);
        }
        return inStream;
    }

    public static Object getInstance(String className) throws ObjectCreationException {
        return ResourceLoader.getInstance(className, null);
    }

    public static Object getInstance(String className, ClassLoader loader) throws ObjectCreationException {
        try {
            return ResourceLoader.getClass(className, loader).newInstance();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("class:" + className), (Throwable)e);
            }
            throw new ObjectCreationException("class:'" + className, e);
        }
    }

    public static Object getInstance(String className, ClassLoader loader, Class[] parameterTypes, Object[] parameterValues) throws ObjectCreationException {
        try {
            Class c = ResourceLoader.getClass(className, loader);
            Constructor constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameterValues);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("class:" + className), (Throwable)e);
            }
            throw new ObjectCreationException("class:'" + className, e);
        }
    }

    public static Object getInstance(Class c) throws ObjectCreationException {
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("class:" + c), (Throwable)e);
            }
            throw new ObjectCreationException("class:" + c, e);
        }
    }

    public static Object getInstance(Class c, Class[] parameterTypes, Object[] parameterValues) throws ObjectCreationException {
        try {
            Constructor constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameterValues);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("class:" + c), (Throwable)e);
            }
            throw new ObjectCreationException("class:" + c, e);
        }
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method = clazz.getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return classLoader;
    }
}

