/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.util.Format;

public class IntrospectPrintStream
extends PrintStream {
    public IntrospectPrintStream() {
        this(System.out);
    }

    public IntrospectPrintStream(boolean autoFlush) {
        this(System.out, autoFlush);
    }

    public IntrospectPrintStream(OutputStream out) {
        this(out, false);
    }

    public IntrospectPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void print(Object o) {
        if (o == null) {
            this.printNull();
            return;
        }
        if (o.getClass().isArray()) {
            this.printArray(o);
        } else if (o instanceof Map) {
            this.printMap((Map)o);
        } else if (o instanceof Collection) {
            this.printColl((Collection)o);
        } else {
            super.print(o);
        }
    }

    public void printlf(int len) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            int i = 0;
            while (i < len) {
                this.println();
                ++i;
            }
        }
    }

    public void printsp(int len) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            int i = 0;
            while (i < len) {
                this.print(' ');
                ++i;
            }
        }
    }

    public void printArray(Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (a == null) {
                this.printNull();
            } else if (a.getClass().isArray()) {
                this.printClass(a);
                this.printDeepArrays(a);
            } else {
                super.print(a);
            }
        }
    }

    public void printArray(Object title, Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            this.print(title);
            this.print(" : ");
            this.println();
            this.printArray(a);
            this.println();
        }
    }

    public void printColl(Collection c) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (c == null) {
                this.printNull();
            } else if (c.size() == 0) {
                this.printClass(c);
                this.print("[]");
            } else {
                this.printClass(c);
                super.print('[');
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                while (hasNext) {
                    Object o = i.next();
                    this.print((Object)(o == c ? "(this Collection)" : o));
                    hasNext = i.hasNext();
                    if (!hasNext) continue;
                    super.print(", ");
                }
                super.print(']');
            }
        }
    }

    public void printMap(Map m) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (m == null) {
                this.printNull();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.print("{}");
            } else {
                this.printClass(m);
                this.print('{');
                boolean st = true;
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (st) {
                        st = false;
                    } else {
                        this.print(", ");
                    }
                    this.print((Object)(key == m ? "(this Map)" : key));
                    this.print(':');
                    this.print((Object)(value == m ? "(this Map)" : value));
                }
                this.print('}');
            }
        }
    }

    public void printBean(Object bean) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            Map props;
            try {
                props = BeanUtilities.getProperties(bean);
            }
            catch (Exception e) {
                this.println();
                return;
            }
            this.printClass(bean);
            this.print('{');
            boolean st = true;
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ("class".equals(e.getKey())) continue;
                if (st) {
                    st = false;
                } else {
                    this.print(", ");
                }
                this.print((String)e.getKey());
                this.print('=');
                this.print(e.getValue());
            }
            this.print('}');
        }
    }

    public void printBeans(Object[] beans) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            this.printClass(beans);
            this.println();
            this.println('[');
            int i = 0;
            while (i < beans.length) {
                this.printsp(2);
                this.print('[');
                this.print(i);
                this.print(']');
                this.printBean(beans[i]);
                this.println();
                ++i;
            }
            this.println(']');
        }
    }

    public void printConstants(Class c) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            try {
                this.printClass(c);
                Field[] fields = c.getFields();
                this.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                        this.printsp(2);
                        this.print("public static final ");
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(null));
                    }
                    ++i;
                }
                this.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printFields(Object o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            try {
                this.printClass(o);
                Field[] fields = o.getClass().getFields();
                this.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers)) {
                        this.printsp(2);
                        this.print("public ");
                        if (Modifier.isStatic(modifiers)) {
                            this.print("static ");
                        }
                        if (Modifier.isFinal(modifiers)) {
                            this.print("final ");
                        }
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        if (Modifier.isVolatile(modifiers)) {
                            this.print("volatile ");
                        }
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(o));
                    }
                    ++i;
                }
                this.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printClass(Object o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (o == null) {
                return;
            }
            super.print('<');
            super.print(o instanceof Class ? ((Class)o).getName() : o.getClass().getName());
            super.print('>');
        }
    }

    public void printClass(Object[] o) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (o == null) {
                return;
            }
            super.print('<');
            this.print(o.getClass().getComponentType().getName());
            this.print('[');
            this.print(o.length);
            this.print(']');
            super.print('>');
        }
    }

    public void printNull() {
        this.print("null");
    }

    protected void printDeepArrays(Object a) {
        IntrospectPrintStream introspectPrintStream = this;
        synchronized (introspectPrintStream) {
            if (a == null) {
                this.printNull();
                return;
            }
            Class<?> aClass = a.getClass();
            if (aClass.isArray()) {
                Class<?> type = aClass.getComponentType();
                if (type.isPrimitive()) {
                    super.print(Format.toString(a));
                } else {
                    this.printDeepArrays((Object[])a, new HashSet(), 0);
                }
            } else {
                this.print(a);
            }
        }
    }

    private void printDeepArrays(Object[] a, Set dejaVu, int row) {
        if (a == null) {
            this.printNull();
            return;
        }
        dejaVu.add(a);
        super.print('[');
        int i = 0;
        while (i < a.length) {
            Object e;
            if (i != 0) {
                this.print(", ");
            }
            if ((e = a[i]) == null) {
                this.printNull();
            } else if (dejaVu.contains(e)) {
                super.print("[...]");
            } else {
                Class<?> eClass = e.getClass();
                if (eClass.isArray()) {
                    Class<?> type = eClass.getComponentType();
                    if (type.isPrimitive()) {
                        super.print(Format.toString(e));
                    } else {
                        this.printDeepArrays((Object[])e, dejaVu, row + 1);
                    }
                } else {
                    this.print(e);
                }
            }
            ++i;
        }
        super.print(']');
        dejaVu.remove(a);
    }
}

