/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.wrapper;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.wrapper.WrappedCollection;
import shohaku.core.collections.wrapper.WrappedIterator;
import shohaku.core.collections.wrapper.WrappedSet;

public class WrappedGroup
implements Group,
Serializable {
    protected final Group group;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;

    public WrappedGroup(Group g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.group = g;
    }

    public Collection get(Object key) {
        return new WrappedCollection(this.group.get(key));
    }

    public int size() {
        return this.group.size();
    }

    public int size(Object key) {
        return this.group.size(key);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new WrappedSet(this.group.keySet());
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new WrappedGroupEntrySet(this.group.entrySet());
        }
        return this.entrySet;
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.group.containsKey(key);
    }

    public boolean containsValue(Object key, Object value) {
        return this.group.containsValue(key, value);
    }

    public Iterator iterator() {
        return new WrappedIterator(this.group.iterator());
    }

    public Iterator iterator(Object key) {
        return new WrappedIterator(this.group.iterator(key));
    }

    public boolean add(Object key) {
        return this.group.add(key);
    }

    public boolean add(Object key, Object value) {
        return this.group.add(key, value);
    }

    public void addAll(Group g) {
        this.group.addAll(g);
    }

    public boolean addAll(Object key, Collection c) {
        return this.group.addAll(key, c);
    }

    public Collection remove(Object key) {
        return new WrappedCollection(this.group.remove(key));
    }

    public boolean remove(Object key, Object value) {
        return this.group.remove(key, value);
    }

    public void clear() {
        this.group.clear();
    }

    public boolean equals(Object o) {
        return this.group.equals(o);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public String toString() {
        return this.group.toString();
    }

    protected class WrappedGroupEntrySet
    extends WrappedSet {
        protected WrappedGroupEntrySet(Set s) {
            super(s);
        }

        public Iterator iterator() {
            return this.wrappedIterator(this.coll.iterator());
        }

        public Object[] toArray() {
            Object[] a = this.coll.toArray();
            int i = 0;
            while (i < a.length) {
                a[i] = this.wrappedEntry((Group.Entry)a[i]);
                ++i;
            }
            return a;
        }

        public Object[] toArray(Object[] a) {
            Object[] arr = this.coll.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
            int i = 0;
            while (i < arr.length) {
                arr[i] = this.wrappedEntry((Group.Entry)arr[i]);
                ++i;
            }
            if (arr.length > a.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            if (a.length > arr.length) {
                a[arr.length] = null;
            }
            return a;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Group.Entry)) {
                return false;
            }
            return this.coll.contains(this.wrappedEntry((Group.Entry)o));
        }

        public boolean containsAll(Collection coll) {
            Iterator e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        protected Iterator wrappedIterator(Iterator iterator) {
            return new WrappedIterator(this, iterator){
                final /* synthetic */ WrappedGroupEntrySet this$1;
                {
                    this.this$1 = wrappedGroupEntrySet;
                }

                public Object next() {
                    return this.this$1.wrappedEntry((Group.Entry)this.i.next());
                }
            };
        }

        protected Group.Entry wrappedEntry(Group.Entry entry) {
            return new WrappedGroupEntry(entry);
        }
    }

    protected class WrappedGroupEntry
    implements Group.Entry {
        protected final Group.Entry e;

        protected WrappedGroupEntry(Group.Entry e) {
            this.e = e;
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Collection getValues() {
            return new WrappedCollection(this.e.getValues());
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        public String toString() {
            return this.e.toString();
        }
    }
}

