/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.wrapper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.collections.wrapper.UnmodifiableCollection;
import shohaku.core.collections.wrapper.UnmodifiableIterator;
import shohaku.core.collections.wrapper.UnmodifiableSet;
import shohaku.core.collections.wrapper.WrappedMap;

public class UnmodifiableMap
extends WrappedMap {
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    public UnmodifiableMap(Map m) {
        super(m);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new UnmodifiableSet(this.map.keySet());
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnmodifiableEntrySet(this.map.entrySet());
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new UnmodifiableCollection(this.map.values());
        }
        return this.values;
    }

    protected class UnmodifiableEntrySet
    extends UnmodifiableSet {
        protected UnmodifiableEntrySet(Set s) {
            super(s);
        }

        public Iterator iterator() {
            return this.wrappedIterator(this.coll.iterator());
        }

        public Object[] toArray() {
            Object[] a = this.coll.toArray();
            int i = 0;
            while (i < a.length) {
                a[i] = this.wrappedEntry((Map.Entry)a[i]);
                ++i;
            }
            return a;
        }

        public Object[] toArray(Object[] a) {
            Object[] arr = this.coll.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
            int i = 0;
            while (i < arr.length) {
                arr[i] = this.wrappedEntry((Map.Entry)arr[i]);
                ++i;
            }
            if (arr.length > a.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            if (a.length > arr.length) {
                a[arr.length] = null;
            }
            return a;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.coll.contains(this.wrappedEntry((Map.Entry)o));
        }

        public boolean containsAll(Collection coll) {
            Iterator e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set s = (Set)o;
            if (s.size() != this.coll.size()) {
                return false;
            }
            return this.containsAll((Collection)s);
        }

        protected Iterator wrappedIterator(Iterator iterator) {
            return new UnmodifiableIterator(this, iterator){
                final /* synthetic */ UnmodifiableEntrySet this$1;
                {
                    this.this$1 = unmodifiableEntrySet;
                }

                public Object next() {
                    return this.this$1.wrappedEntry((Map.Entry)super.next());
                }
            };
        }

        protected Map.Entry wrappedEntry(Map.Entry entry) {
            return new UnmodifiableEntry(entry);
        }
    }

    protected class UnmodifiableEntry
    extends WrappedMap.WrappedMapEntry {
        protected UnmodifiableEntry(Map.Entry e) {
            super(e);
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

