/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.wrapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.wrapper.WrappedGroup;

public class SynchronizedGroup
extends WrappedGroup {
    protected final Object mutex = this;

    public SynchronizedGroup(Group g) {
        super(g);
    }

    public Collection get(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return Collections.synchronizedCollection(this.group.get(key));
        }
    }

    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.size();
        }
    }

    public int size(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.size(key);
        }
    }

    public Set keySet() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.keySet == null) {
                this.keySet = Collections.synchronizedSet(this.group.keySet());
            }
            return this.keySet;
        }
    }

    public Set entrySet() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.entrySet == null) {
                this.entrySet = Collections.synchronizedSet(this.group.entrySet());
            }
            return this.entrySet;
        }
    }

    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.isEmpty();
        }
    }

    public boolean containsKey(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.containsKey(key);
        }
    }

    public boolean containsValue(Object key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.containsValue(key, value);
        }
    }

    public Iterator iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.iterator();
        }
    }

    public Iterator iterator(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.iterator(key);
        }
    }

    public boolean add(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.add(key);
        }
    }

    public boolean add(Object key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.add(key, value);
        }
    }

    public void addAll(Group g) {
        Object object = this.mutex;
        synchronized (object) {
            this.group.addAll(g);
        }
    }

    public boolean addAll(Object key, Collection c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.addAll(key, c);
        }
    }

    public Collection remove(Object key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.remove(key);
        }
    }

    public boolean remove(Object key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.remove(key, value);
        }
    }

    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.group.clear();
        }
    }

    public boolean equals(Object o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.equals(o);
        }
    }

    public int hashCode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.hashCode();
        }
    }

    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.group.toString();
        }
    }
}

