/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.group;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.IteratorUtils;

public abstract class AbstractMapGroup
implements Group {
    protected final Map groupMap;
    private transient Set entrySet = null;

    protected AbstractMapGroup(Map groupMap) {
        this.groupMap = groupMap;
    }

    public void clear() {
        this.groupMap.clear();
    }

    public boolean isEmpty() {
        return this.groupMap.isEmpty();
    }

    public boolean add(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.addEntry(key);
    }

    public boolean add(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.addEntryValue(key, value);
    }

    public boolean addAll(Object key, Collection c) {
        if (key == null || c == null) {
            throw new NullPointerException();
        }
        return this.addEntryValues(key, c);
    }

    public void addAll(Group g) {
        if (g == null) {
            throw new NullPointerException();
        }
        this.addAllEntrys(g);
    }

    public Iterator iterator() {
        return this.newEntryIterator();
    }

    public Iterator iterator(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Collection values = this.getEntryValues(key);
        return values != null ? values.iterator() : IteratorUtils.EMPTY_ITERATOR;
    }

    public Collection get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getEntryValues(key);
    }

    public Collection remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.removeEntryByKey(key);
    }

    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.removeValue(key, value);
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.groupMap.containsKey(key);
    }

    public boolean containsValue(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Collection c = this.getEntryValues(key);
        return c != null ? c.contains(value) : false;
    }

    public Set keySet() {
        return this.groupMap.keySet();
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    public int size() {
        return this.groupMap.size();
    }

    public int size(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Collection c = this.getEntryValues(key);
        return c != null ? c.size() : 0;
    }

    public int hashCode() {
        int h = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group t = (Group)o;
        if (t.size() != this.size()) {
            return false;
        }
        return this.entrySet().equals(t.entrySet());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Group.Entry e = (Group.Entry)i.next();
            Object key = e.getKey();
            Collection values = e.getValues();
            buf.append(key == this ? "(this Group)" : key);
            buf.append('=');
            buf.append(values == this ? "(this Group)" : values);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected boolean containsEntry(Group.Entry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        return this.groupMap.containsValue(entry);
    }

    protected boolean removeEntry(Group.Entry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Group.Entry e = (Group.Entry)i.next();
            if (!e.equals(entry)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    protected Group.Entry getEntry(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (Group.Entry)this.groupMap.get(key);
    }

    protected Collection getEntryValues(Object key) {
        Group.Entry e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        return e.getValues();
    }

    protected boolean addEntry(Object key) {
        boolean ret = true;
        Group.Entry e = this.getEntry(key);
        if (e == null) {
            e = this.newEntry(key);
            this.groupMap.put(key, e);
            ret = false;
        }
        return ret;
    }

    protected Collection removeEntryByKey(Object key) {
        Group.Entry e = (Group.Entry)this.groupMap.remove(key);
        if (e == null) {
            return null;
        }
        return e.getValues();
    }

    protected boolean removeValue(Object key, Object value) {
        Collection c = this.getEntryValues(key);
        return c != null ? c.remove(value) : false;
    }

    protected boolean addEntryValue(Object key, Object value) {
        boolean ret = true;
        Group.Entry e = this.getEntry(key);
        if (e == null) {
            e = this.newEntry(key);
            this.groupMap.put(key, e);
            ret = false;
        }
        e.getValues().add(value);
        return ret;
    }

    protected boolean addEntryValues(Object key, Collection values) {
        boolean ret = true;
        Group.Entry e = this.getEntry(key);
        if (e == null) {
            e = this.newEntry(key);
            this.groupMap.put(key, e);
            ret = false;
        }
        e.getValues().addAll(values);
        return ret;
    }

    protected void addAllEntrys(Group g) {
        Iterator i = g.iterator();
        while (i.hasNext()) {
            Group.Entry entry = (Group.Entry)i.next();
            this.addEntryValues(entry.getKey(), entry.getValues());
        }
    }

    protected Group.Entry newEntry(Object key) {
        return this.newEntry(key, this.newEntryCollection());
    }

    protected Iterator newEntryIterator() {
        return this.groupMap.values().iterator();
    }

    protected Group.Entry newEntry(Object key, Collection values) {
        return new SimpleEntry(key, values);
    }

    public abstract Object clone();

    protected abstract Collection newEntryCollection();

    protected static class SimpleEntry
    implements Group.Entry {
        protected final Object key;
        protected final Collection values;

        protected SimpleEntry(Object k, Collection v) {
            this.key = k;
            this.values = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Collection getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Group.Entry)) {
                return false;
            }
            Group.Entry e = (Group.Entry)o;
            return this.key.equals(e.getKey()) && this.values.equals(e.getValues());
        }

        public int hashCode() {
            return this.key.hashCode() + this.values.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.values;
        }
    }

    private static class EntrySet
    extends AbstractSet {
        private final AbstractMapGroup group;

        public EntrySet(AbstractMapGroup g) {
            this.group = g;
        }

        public Iterator iterator() {
            return this.group.iterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Group.Entry)) {
                return false;
            }
            Group.Entry e = (Group.Entry)o;
            return this.group.containsEntry(e);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Group.Entry)) {
                return false;
            }
            Group.Entry e = (Group.Entry)o;
            return this.group.removeEntry(e);
        }

        public int size() {
            return this.group.size();
        }

        public void clear() {
            this.group.clear();
        }
    }
}

