/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.lang.reflect.Field;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.ClassFeatureInfo;
import shohaku.core.beans.InvocationBeansException;

public class FieldInfo
extends ClassFeatureInfo {
    private String name;

    public FieldInfo() {
    }

    public FieldInfo(String name) {
        this.setName(name);
    }

    public FieldInfo(String name, Class objectType) {
        this.setName(name);
        this.setObjectType(objectType);
    }

    public Object get() throws InvocationBeansException {
        return this.get(this.getObjectType(), null);
    }

    public Object get(Class c) throws InvocationBeansException {
        return this.get(c, null);
    }

    public Object get(Object obj) throws InvocationBeansException {
        if (obj == null) {
            throw new NullPointerException("argument is null.");
        }
        return this.get(obj.getClass(), obj);
    }

    public Object set(Object newValue) throws InvocationBeansException {
        return this.set(this.getObjectType(), null, newValue);
    }

    public Object set(Class c, Object newValue) throws InvocationBeansException {
        return this.set(c, null, newValue);
    }

    public Object set(Object obj, Object newValue) throws InvocationBeansException {
        if (obj == null) {
            throw new NullPointerException("argument obj is null.");
        }
        return this.set(obj.getClass(), obj, newValue);
    }

    private Object get(Class c, Object obj) throws InvocationBeansException {
        if (c == null) {
            throw new NullPointerException("argument class is null.");
        }
        Field field = this.getField(c);
        return BeanUtilities.getFieldValue(c, obj, field);
    }

    private Object set(Class c, Object obj, Object newValue) throws InvocationBeansException {
        if (c == null) {
            throw new NullPointerException("argument class is null.");
        }
        Field field = this.getField(c);
        return BeanUtilities.setFieldValue(c, obj, field, newValue);
    }

    private Field getField(Class c) throws InvocationBeansException {
        Field field = BeanUtilities.getAccessibleField(c, this.getName());
        if (field == null) {
            throw new InvocationBeansException("no such field. class:" + c + ", field:" + this.getName());
        }
        return field;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkUnmodifiable();
        if (name == null) {
            throw new NullPointerException("argument is null.");
        }
        this.name = name;
    }
}

