/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.lang.reflect.Method;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.BindMethod;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.collections.Parameters;
import shohaku.core.lang.Eval;
import shohaku.core.util.Format;

final class BindMethodImpl
implements BindMethod {
    private Class objectType;
    private Object srcObject;
    private Method method;
    private String methodName;
    private Class[] parameterTypes;
    private Object[] parameterValues;
    private String[] parameterNames;
    private int[] parameterRules;

    BindMethodImpl() {
    }

    public Object invoke(Parameters values) throws InvocationBeansException {
        return this.invokeMethod(this.getObjectType(), this.getSrcObject(), this.getMethod(), values);
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getSrcObject() {
        return this.srcObject;
    }

    public Method getMethod() {
        return this.method;
    }

    void bind() throws InvocationBeansException {
        Class[] types = this.getParameterTypes();
        Object[] values = this.getParameterValues();
        CharSequence[] names = this.getParameterNames();
        int[] rules = this.getParameterRules();
        if (!Eval.isEqualsLength(new Object[]{types, values, names, rules})) {
            throw new InvocationBeansException("parameter is illegal.");
        }
        if (Eval.isOrBlank(names)) {
            throw new InvocationBeansException("parameter is illegal.");
        }
        if (!Eval.isRange(rules, 0, 2)) {
            throw new InvocationBeansException("parameter is illegal.");
        }
        try {
            this.setMethod(this.getMatchingAccessibleMethod());
        }
        catch (NoSuchMethodException e) {
            throw new InvocationBeansException("parameter is illegal.", e);
        }
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    void setObjectType(Class objectType) {
        this.objectType = objectType;
    }

    void setSrcObject(Object srcObject) {
        this.srcObject = srcObject;
    }

    void setParameterNames(String[] parameterNames) {
        this.parameterNames = parameterNames;
    }

    void setParameterRules(int[] parameterRules) {
        this.parameterRules = parameterRules;
    }

    void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    void setParameterValues(Object[] parameterValues) {
        this.parameterValues = parameterValues;
    }

    private void setMethod(Method method) {
        this.method = method;
    }

    private Object[] getParameterValues() {
        return this.parameterValues == null ? new Object[]{} : this.parameterValues;
    }

    private Class[] getParameterTypes() {
        return this.parameterTypes == null ? new Class[]{} : this.parameterTypes;
    }

    private String[] getParameterNames() {
        return this.parameterNames == null ? new String[]{} : this.parameterNames;
    }

    private int[] getParameterRules() {
        return this.parameterRules == null ? new int[]{} : this.parameterRules;
    }

    private Object invokeMethod(Class c, Object obj, Method method, Parameters params) throws InvocationBeansException {
        Object[] values = (Object[])this.getParameterValues().clone();
        String[] names = this.getParameterNames();
        int[] rules = this.getParameterRules();
        int i = 0;
        while (i < values.length) {
            int rule = rules[i];
            String name = names[i];
            if (rule == 1) {
                if (params.containsName(name)) {
                    values[i] = params.getValue(name);
                }
            } else if (rule == 2 && params.containsName(name)) {
                values[i] = params.getValue(name);
            }
            ++i;
        }
        return this.invokeMethod(c, obj, method, values);
    }

    private Object invokeMethod(Class c, Object obj, Method method, Object[] parameterValues) throws InvocationBeansException {
        return BeanUtilities.invokeMethod(c, obj, method, parameterValues);
    }

    private Method getMatchingAccessibleMethod() throws NoSuchMethodException {
        Method method = BeanUtilities.getMatchingAccessibleMethod(this.getObjectType(), this.getMethodName(), this.getParameterTypes());
        if (method == null) {
            throw new NoSuchMethodException(Format.format("class:{0}, method:{1}, args:{2,array}", this.getObjectType(), this.getMethodName(), this.getParameterTypes()));
        }
        return method;
    }
}

