/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

import junit.framework.TestCase;

/**
 * TestEval
 */
public class TestEval extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TestEval.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Constructor for TestEval.
     * 
     * @param arg0
     */
    public TestEval(String arg0) {
        super(arg0);
    }

    public final void testIsBlank() {
        //isBlank() を実装します。
        assertTrue(Eval.isBlank(""));
        assertTrue(Eval.isBlank(null));
        assertFalse(Eval.isBlank(" "));
        assertFalse(Eval.isBlank("tesuto@iaf"));
    }

    /*
     * boolean isEndBlank のテスト中のクラス(CharSequence, CharSequence)
     */
    public final void testIsEndBlankCharSequenceCharSequence() {
        //isEndBlank() を実装します。
        assertTrue(Eval.isEndBlank("", ""));
        assertTrue(Eval.isEndBlank(null, null));
        assertTrue(Eval.isEndBlank(null, ""));
        assertTrue(Eval.isEndBlank("", null));
        assertFalse(Eval.isEndBlank("tesuto@iaf", null));
        assertFalse(Eval.isEndBlank(null, " "));
        assertFalse(Eval.isEndBlank("", "hfasdo;ug"));
        assertFalse(Eval.isEndBlank("tesuto@iaf", ""));
        
    }

    /*
     * boolean isEndBlank のテスト中のクラス(CharSequence[])
     */
    public final void testIsEndBlankCharSequenceArray() {
        //isEndBlank() を実装します。
        assertTrue(Eval.isEndBlank(new String[]{null}));
        assertTrue(Eval.isEndBlank(new String[]{""}));
        assertTrue(Eval.isEndBlank(new String[]{"", "", ""}));
        assertTrue(Eval.isEndBlank(new String[]{null, null, null}));
        assertTrue(Eval.isEndBlank(new String[]{null, "", null}));
        assertTrue(Eval.isEndBlank(new String[]{"", null, null , ""}));
        assertFalse(Eval.isEndBlank(new String[]{null, "", "tesuto@iaf", null}));
        assertFalse(Eval.isEndBlank(new String[]{null, null, " "}));
        assertFalse(Eval.isEndBlank(new String[]{"", null,null,null,"hfasdo;ug"}));
        assertFalse(Eval.isEndBlank(new String[]{"tesuto@iaf"}));
    }

    /*
     * boolean isOrBlank のテスト中のクラス(CharSequence, CharSequence)
     */
    public final void testIsOrBlankCharSequenceCharSequence() {
        //TODO isOrBlank() を実装します。
    }

    /*
     * boolean isOrBlank のテスト中のクラス(CharSequence[])
     */
    public final void testIsOrBlankCharSequenceArray() {
        //TODO isOrBlank() を実装します。
    }

    /*
     * boolean isEmpty のテスト中のクラス(Object[])
     */
    public final void testIsEmptyObjectArray() {
        //TODO isEmpty() を実装します。
    }

    /*
     * boolean isEmpty のテスト中のクラス(Map)
     */
    public final void testIsEmptyMap() {
        //TODO isEmpty() を実装します。
    }

    /*
     * boolean isEmpty のテスト中のクラス(Collection)
     */
    public final void testIsEmptyCollection() {
        //TODO isEmpty() を実装します。
    }

    public final void testIsNull() {
        //TODO isNull() を実装します。
    }

    /*
     * boolean isEndNull のテスト中のクラス(Object, Object)
     */
    public final void testIsEndNullObjectObject() {
        //TODO isEndNull() を実装します。
    }

    /*
     * boolean isEndNull のテスト中のクラス(Object[])
     */
    public final void testIsEndNullObjectArray() {
        //TODO isEndNull() を実装します。
    }

    /*
     * boolean isOrNull のテスト中のクラス(Object, Object)
     */
    public final void testIsOrNullObjectObject() {
        //TODO isOrNull() を実装します。
    }

    /*
     * boolean isOrNull のテスト中のクラス(Object[])
     */
    public final void testIsOrNullObjectArray() {
        //TODO isOrNull() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(char, char, char)
     */
    public final void testIsRangecharcharchar() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(CharSequence, char, char)
     */
    public final void testIsRangeCharSequencecharchar() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(CharSequence, int, char, char)
     */
    public final void testIsRangeCharSequenceintcharchar() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(int, int, int)
     */
    public final void testIsRangeintintint() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(long, long, long)
     */
    public final void testIsRangelonglonglong() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isRange のテスト中のクラス(double, double, double)
     */
    public final void testIsRangedoubledoubledouble() {
        //TODO isRange() を実装します。
    }

    /*
     * boolean isDate のテスト中のクラス(CharSequence, String)
     */
    public final void testIsDateCharSequenceString() {
        //TODO isDate() を実装します。
    }

    /*
     * boolean isDate のテスト中のクラス(CharSequence, String[])
     */
    public final void testIsDateCharSequenceStringArray() {
        //TODO isDate() を実装します。
    }

    /*
     * boolean isDecimal のテスト中のクラス(CharSequence, String)
     */
    public final void testIsDecimalCharSequenceString() {
        //TODO isDecimal() を実装します。
    }

    /*
     * boolean isDecimal のテスト中のクラス(CharSequence, String[])
     */
    public final void testIsDecimalCharSequenceStringArray() {
        //TODO isDecimal() を実装します。
    }

    /*
     * boolean isEncode のテスト中のクラス(char, String)
     */
    public final void testIsEncodecharString() {
        //TODO isEncode() を実装します。
    }

    /*
     * boolean isEncode のテスト中のクラス(char, Charset)
     */
    public final void testIsEncodecharCharset() {
        //TODO isEncode() を実装します。
    }

    /*
     * boolean isEncode のテスト中のクラス(CharSequence, String)
     */
    public final void testIsEncodeCharSequenceString() {
        //TODO isEncode() を実装します。
    }

    /*
     * boolean isEncode のテスト中のクラス(CharSequence, Charset)
     */
    public final void testIsEncodeCharSequenceCharset() {
        //TODO isEncode() を実装します。
    }
}
