/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections;

import java.util.Iterator;

import junit.framework.TestCase;
import shohaku.core.lang.Boxing;
import shohaku.core.util.debug.Debug;

/**
 * TestParameters
 */
public class TestParameters extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(TestParameters.class);
    }

    String[] parametersNames = new String[] { "a", "b", "c" };
    Object[] parametersVlaues = new Object[] { Boxing.box(0), Boxing.box(1), Boxing.box(2) };

    Parameters parameters = new Parameters(parametersNames);
    {
        for (int i = 0; i < parametersVlaues.length; i++) {
            parameters.setValue(i, parametersVlaues[i]);
        }
    }

    /**
     * 
     * @throws java.lang.Exception
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    public final void testHashCode() {
        //TODO hashCode() を実装します。
    }

    /*
     * void Parameters のテスト中のクラス()
     */
    public final void testParameters() {
        //Parameters() を実装します。
        Parameters p = new Parameters();
        assertEquals(p.size(), 0);
    }

    /*
     * void Parameters のテスト中のクラス(String[])
     */
    public final void testParametersStringArray() {
        //Parameters() を実装します。
        String[] names = new String[] { "a", "b", "c" };
        Parameters p = new Parameters(names);
        int c = 0;
        for (Iterator i = p.iterator(); i.hasNext();) {
            Parameters.Entry e = (Parameters.Entry) i.next();
            assertEquals(e.getName().equals(names[c]), true);
            c++;
        }
    }

    /*
     * void Parameters のテスト中のクラス(Parameters)
     */
    public final void testParametersParameters() {
        //Parameters() を実装します。
        Parameters parameters2 = new Parameters(parameters);
        assertEquals(parameters2, parameters);
    }

    public final void testSize() {
        //size() を実装します。
        assertEquals(parameters.size(), parametersNames.length);
    }

    public final void testIterator() {
        //TODO iterator() を実装します。
    }

    public final void testGetName() {
        //getName() を実装します。
        for (int i = 0; i < parametersNames.length; i++) {
            assertEquals(parameters.getName(i), parametersNames[i]);
        }
    }

    public final void testGetIndex() {
        //getIndex() を実装します。
        for (int i = 0; i < parametersNames.length; i++) {
            assertEquals(parameters.getIndex(parametersNames[i]), i);
        }
    }

    /*
     * Object getValue のテスト中のクラス(String)
     */
    public final void testGetValueString() {
        //getValue() を実装します。
        for (int i = 0; i < parametersNames.length; i++) {
            assertEquals(parameters.getValue(parametersNames[i]), parametersVlaues[i]);
        }
    }

    /*
     * Object getValue のテスト中のクラス(int)
     */
    public final void testGetValueint() {
        //getValue() を実装します。
//      getValue() を実装します。
        for (int i = 0; i < parametersNames.length; i++) {
            assertEquals(parameters.getValue(i), parametersVlaues[i]);
        }
    }

    /*
     * Object setValue のテスト中のクラス(String, Object)
     */
    public final void testSetValueStringObject() {
        //TODO setValue() を実装します。
    }

    /*
     * Object setValue のテスト中のクラス(int, Object)
     */
    public final void testSetValueintObject() {
        //TODO setValue() を実装します。
    }

    /*
     * Entry getEntry のテスト中のクラス(String)
     */
    public final void testGetEntryString() {
        //TODO getEntry() を実装します。
    }

    /*
     * Entry getEntry のテスト中のクラス(int)
     */
    public final void testGetEntryint() {
        //TODO getEntry() を実装します。
    }

    public final void testContainsName() {
        //TODO containsName() を実装します。
    }

    /*
     * boolean equals のテスト中のクラス(Object)
     */
    public final void testEqualsObject() {
        //TODO equals() を実装します。
    }

    /*
     * String toString のテスト中のクラス()
     */
    public final void testToString() {
        //toString() を実装します。
        Debug.out.println(parameters.toString());
    }

    /*
     * Object clone のテスト中のクラス()
     */
    public final void testClone() {
        //clone() を実装します。
        Parameters clone = (Parameters)parameters.clone();
        assertEquals(parameters, clone);
        
    }

}
