/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.util.debug;

/**
 * 標準出力ストリームへ出力する <code>DebugPrintStream</code> を使用した <code>System.out</code> の拡張機能を提供します。 <br>
 * <br>
 * 簡易的なデバック文出力への利用を想定しており <code>System.out.print()</code> と同感覚で、より書式化された詳細な出力を得ることが出来ます。
 * 
 * @see shohaku.core.util.debug.DebugPrintStream
 */
public class Debug {

    /** <code>System.out</code> に出力する <code>DebugPrintStream</code> を定義します。 */
    public static final DebugPrintStream out = new DebugPrintStream(System.out, true);

    /** <code>System.err</code> に出力する <code>DebugPrintStream</code> を定義します。 */
    public static final DebugPrintStream err = new DebugPrintStream(System.err, true);

}
