/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util.cel;

/**
 * 式をマッピングするリテラル文字を示します。
 */
public class Literal {

    /** 開始を示すリテラル文字 */
    public final char begin;

    /** 終了を示すリテラル文字 */
    public final char end;

    /**
     * リテラル文字を格納して初期化します。
     * 
     * @param begin
     *            開始を示すリテラル文字
     * @param end
     *            終了を示すリテラル文字
     */
    public Literal(char begin, char end) {
        this.begin = begin;
        this.end = end;
    }

    /**
     * ハッシュコード値を返します。
     * 
     * @return ハッシュコード値
     */
    public int hashCode() {
        return begin + end;
    }

    /**
     * 同値性を比較します。
     * 
     * @param o
     *            比較するオブジェクト
     * @return 等しい場合は true
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Literal)) {
            return false;
        }
        Literal s = (Literal) o;
        return (this.begin == s.begin && this.end == s.end);
    }
}