/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util.cel;

import shohaku.core.collections.Parameters;

/**
 * リテラル文字で論理分割される「式」を定義します。
 * 合成される式文の個々のノードの実体です。
 */
public interface Expression {

    /**
     * 文字列式内のこの式の区画を分割するリテラル文字を返します。
     * 
     * @return リテラル文字
     */
    Literal[] getLiteral();

    /**
     * 式を実行して値を返します。
     * 
     * @param binder
     *            処理基のバインダー
     * @param literal
     *            リテラル文字
     * @param expression
     *            式
     * @param begin
     *            開始インデックス
     * @param end
     *            終了インデックス
     * @param values
     *            引数値の一覧
     * @return 式の結果
     */
    Object execute(CELBinder binder, Literal literal, String expression, int begin, int end, Parameters values);

    /**
     * 次の式の開始インデックス（式の終端の次）を検索して返します。 発見出来ない場合は -1 を返します。
     * 
     * @param binder
     *            処理基のバインダー
     * @param expression
     *            式
     * @param literal
     *            リテラル文字
     * @param begin
     *            式の開始インデックス
     * @return 次の式の開始インデックス
     */
    int findNextIndex(CELBinder binder, Literal literal, String expression, int begin);
}