/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util;

/**
 * 参照基から変更不可能な状態へ移行する機能を定義します。 <br>
 * <br>
 * <code>isUnmodifiable()</code> が <code>true</code> を返す状態の場合は、そのオブジェクトは参照基からは変更不可能となります。 <br>
 * 実装クラスは、変更不可能の状態において変更要求が行われた場合は <code>UnmodifiableStateException</code> を発生させる必要があります。
 */
public interface UnmodifiableChangedObject {

    /**
     * 参照基から変更不可能な状態を持つ場合 <code>true</code> を返却します．
     * 
     * @return 参照基から変更不可能な状態を持つ場合 <code>true</code>
     */
    public boolean isUnmodifiable();

    /**
     * <code>true</code> を指定すると参照基から変更不可能な状態に移行します． <br>
     * 変更不可の状態で <code>true</code> を指定しても何も発生しません。 <br>
     * 変更不可の状態で <code>false</code> が指定された場合 <code>UnmodifiableStateException</code> が発生します．
     * 
     * @param unmodifiable
     *            参照基から変更不可能な状態へ遷移する場合 <code>true</code>
     * @throws UnmodifiableStateException
     *             変更不可の状態で呼び出された場合
     */
    public void setUnmodifiable(boolean unmodifiable);

}
