/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.util;

/**
 * フォーマット変換を行うユーティリティメソッドを提供します。
 */
public class Format {

    /**
     * オブジェクトの書式化した文字列表現を生成して返します。
     * 
     * @param o
     *            生成基のオブジェクト
     * @return 書式化した文字列表現
     */
    public static String toString(Object o) {
        return ToStringHelper.toString(o, ToStringHelper.NORMAL);
    }

    /**
     * オブジェクトの深層の情報を含み書式化した文字列表現を生成して返します。
     * 
     * @param o
     *            生成基のオブジェクト
     * @return 深層の情報を含み書式化した文字列表現
     */
    public static String deepToString(Object o) {
        return ToStringHelper.deepToString(o, ToStringHelper.NORMAL);
    }

    /**
     * <code>MessageFormatBinder</code> のデフォルトを使用して書式化された文字列を返します。
     * 
     * @param pattern
     *            書式化パターン
     * @param value
     *            生成する要素となるオブジェクト
     * @return 書式化された文字列
     */
    public static String format(String pattern, Object value) {
        return format(pattern, new Object[] { value });
    }

    /**
     * <code>MessageFormatBinder</code> のデフォルトを使用して書式化された文字列を返します。
     * 
     * @param pattern
     *            書式化パターン
     * @param value
     *            第一の生成する要素となるオブジェクト
     * @param value2
     *            第二の生成する要素となるオブジェクト
     * @return 書式化された文字列
     */
    public static String format(String pattern, Object value, Object value2) {
        return format(pattern, new Object[] { value, value2 });
    }

    /**
     * <code>MessageFormatBinder</code> のデフォルトを使用して書式化された文字列を返します。
     * 
     * @param pattern
     *            書式化パターン
     * @param value
     *            第一の生成する要素となるオブジェクト
     * @param value2
     *            第二の生成する要素となるオブジェクト
     * @param value3
     *            第三の生成する要素となるオブジェクト
     * @return 書式化された文字列
     */
    public static String format(String pattern, Object value, Object value2, Object value3) {
        return format(pattern, new Object[] { value, value2, value3 });
    }

    /**
     * <code>MessageFormatBinder</code> のデフォルトを使用して書式化された文字列を返します。
     * 
     * @param pattern
     *            書式化パターン
     * @param values
     *            生成する要素となるオブジェクト
     * @return 書式化された文字列
     */
    public static String format(String pattern, Object[] values) {
        return MessageFormatBinder.getDefaultBinder().format(pattern, values);
    }

}
