/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.lang;

/**
 * 基本的なクラスのユーティリティメソッドを提供します。
 */
public class LangUtils {

    /**
     * １次元または多次元配列の基に為るクラス型を取得します。配列以外の場合は指定のクラスがそのまま返ります。 <br>
     * 例：<code>java.lang.String[][]</code> の配列型に対しては <code>java.lang.String</code> クラスが返されます。
     * 
     * @param c
     *            検証するクラス
     * @return １次元または多次元配列の基に為るクラス型
     * @throws NullPointerException
     *             引数に <code>null</code> が指定された場合
     */
    public static Class getSourceComponentType(Class c) {
        if (c.isArray()) {
            return getSourceComponentType(c.getComponentType());
        }
        return c;
    }

}
