/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.collections.wrapper;

import java.util.ListIterator;

/**
 * 指定されたリストの反復子をラッピングするビューを定義します。 <br>
 * <br>
 * このクラスはリストの反復子の実装を隠蔽する目的で使用されます。またリストの反復子をラッピングするクラスの基底実装の役割を持ちます。
 */
public class WrappedListIterator extends WrappedIterator implements ListIterator {

    /** 基となるリストの反復子。 */
    protected final ListIterator li;

    /**
     * ラップするリストの反復子を指定して初期化します。
     * 
     * @param i
     *            ラップするリストの反復子
     */
    public WrappedListIterator(ListIterator i) {
        super(i);
        this.li = i;
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#hasPrevious()
     */
    public boolean hasPrevious() {
        return li.hasPrevious();
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#previous()
     */
    public Object previous() {
        return li.previous();
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#nextIndex()
     */
    public int nextIndex() {
        return li.nextIndex();
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#previousIndex()
     */
    public int previousIndex() {
        return li.previousIndex();
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#set(java.lang.Object)
     */
    public void set(Object o) {
        li.set(o);
    }

    /**
     * 基となるリストの反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#add(java.lang.Object)
     */
    public void add(Object o) {
        li.add(o);
    }
}