/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.collections.wrapper;

import java.util.Iterator;

/**
 * 指定された反復子の変更不可能なビュー定義します。
 */
public class UnmodifiableIterator extends WrappedIterator {

    /**
     * ラップする反復子を指定して初期化します。
     * 
     * @param iterator
     *            ラップする反復子
     */
    public UnmodifiableIterator(Iterator iterator) {
        super(iterator);
    }

    /**
     * <code>UnsupportedOperationException</code> を発生させます。
     * 
     * @see java.util.Iterator#remove()
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
}