/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.beans;

import shohaku.core.util.UnmodifiableStateException;

/**
 * メソッドのパラメータ情報を格納する機能を提供します。
 */
public class ParameterInfo extends FeatureInfo {

    /* パラメータの型。 */
    private Class type;

    /* パラメータの値。 */
    private Object value;

    /**
     * デフォルトコンストラクタ。
     */
    public ParameterInfo() {
        super();
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param type
     *            パラメータの型
     * @param value
     *            パラメータの値
     */
    public ParameterInfo(Class type, Object value) {
        setType(type);
        setValue(value);
    }

    /*
     * Property
     */

    /**
     * パラメータの型を返却します。
     * 
     * @return パラメータの型
     */
    public Class getType() {
        return type;
    }

    /**
     * パラメータの値を返却します。
     * 
     * @return パラメータの値
     */
    public Object getValue() {
        return value;
    }

    /**
     * パラメータの型を格納します。
     * 
     * @param c
     *            パラメータの型
     * @throws UnmodifiableStateException
     *             変更不可の状態で呼び出された場合
     */
    public void setType(Class c) {
        checkUnmodifiable();

        if (c == null) {
            throw new NullPointerException("argument is null.");
        }
        this.type = c;
    }

    /**
     * パラメータの値を格納します。
     * 
     * @param o
     *            パラメータの値
     * @throws UnmodifiableStateException
     *             変更不可の状態で呼び出された場合
     */
    public void setValue(Object o) {
        checkUnmodifiable();

        this.value = o;
    }

}
