/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans;

import shohaku.core.util.UnmodifiableStateException;

/**
 * クラス情報を格納しクラスの機能へアクセスする機能の一般化された定義を提供します。
 */
public class ClassFeatureInfo extends FeatureInfo {

    /*
     * Property
     */

    /* 実行基のオブジェクト型。 */
    private Class objectType;

    /**
     * 実行基のオブジェクト型を返却します。
     * 
     * @return 実行基のオブジェクト型
     */
    public Class getObjectType() {
        return objectType;
    }

    /**
     * 実行基のオブジェクト型を格納します。 <br>
     * 
     * @param type
     *            実行基のオブジェクト型
     * @throws UnmodifiableStateException
     *             変更不可の状態で呼び出された場合
     */
    public void setObjectType(Class type) {
        checkUnmodifiable();

        if (type == null) {
            throw new NullPointerException("argument is null.");
        }
        this.objectType = type;
    }

}
