/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans;

/**
 * 更新規則と名前で拘束されたパラメータ情報を格納する機能を提供します。
 */
public class BindParameterInfo extends ParameterInfo {

    /* パラメータ拘束名。 */
    private String bindName;

    /* パラメータ拘束ルール。 */
    private int bindRule;

    /**
     * デフォルトコンストラクタ。
     */
    public BindParameterInfo() {
        super();
    }

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param type
     *            パラメータの型
     * @param value
     *            パラメータの値
     * @param bindName
     *            拘束名
     * @param bindRule
     *            拘束ルール
     */
    public BindParameterInfo(Class type, Object value, String bindName, int bindRule) {
        super(type, value);
        setBindName(bindName);
        setBindRule(bindRule);
    }

    /**
     * 拘束名返却します．
     * 
     * @return 拘束名
     */
    public String getBindName() {
        return bindName;
    }

    /**
     * 拘束名を格納します．
     * 
     * @param bindName
     *            拘束名
     */
    public void setBindName(String bindName) {
        checkUnmodifiable();
        if (bindName == null) {
            throw new NullPointerException("argument is null.");
        }
        this.bindName = bindName;
    }

    /**
     * 拘束ルールを返却します．
     * 
     * @return 拘束ルール
     */
    public int getBindRule() {
        return bindRule;
    }

    /**
     * 拘束ルールを格納します．
     * 
     * @param bindRule
     *            拘束ルール
     */
    public void setBindRule(int bindRule) {
        checkUnmodifiable();
        this.bindRule = bindRule;
    }
}
