/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import shohaku.core.collections.Parameters;
import shohaku.core.lang.Seek;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.Expression;
import shohaku.core.util.cel.Literal;

public class ListExpression
implements Expression {
    private static final Literal[] literals = new Literal[]{new Literal('[', ']')};

    public Literal[] getLiteral() {
        return literals;
    }

    public Object execute(CELBinder binder, Literal literal, String expression, int begin, int end, Parameters values) {
        String exp = expression.substring(begin, end).trim();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < exp.length()) {
            int inx = binder.findNextIndex(exp, i);
            if (inx < 0) break;
            list.add(binder.getValue(exp, i, inx, values));
            i = Seek.skipTo((CharSequence)exp, ' ', inx);
            if (i >= exp.length()) break;
            if (',' != exp.charAt(i)) {
                throw new IllegalArgumentException();
            }
            i = Seek.skipTo((CharSequence)exp, ' ', i + 1);
        }
        return list;
    }

    public int findNextIndex(CELBinder binder, Literal literal, String expression, int begin) {
        int end = begin + 1;
        end = Seek.skipTo((CharSequence)expression, ' ', end);
        while (end < expression.length()) {
            char c;
            if (-1 == (end = binder.findNextIndex(expression, end))) {
                return -1;
            }
            if ((end = Seek.skipTo((CharSequence)expression, new char[]{',', ' '}, end)) >= expression.length() || (c = expression.charAt(end)) == ']') break;
        }
        return end + 1;
    }
}

